%define _xconfdir %_sysconfdir/X11/xorg.conf.d

Name: xorg-drv-evdev
Version: 2.11.0
Release: alt1
Epoch: 2
Summary: Generic Linux input driver
License: MIT/X11
Group: System/X11
Url: http://xorg.freedesktop.org
Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq: XORG_ABI_XINPUT = %get_xorg_abi_xinput
Provides: xorg-drv-mouse = %epoch:%version-%release xorg-drv-keyboard = %epoch:%version-%release
Obsoletes: xorg-drv-mouse xorg-drv-keyboard

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(Pre): xorg-sdk
BuildRequires: libevdev-devel libmtdev-devel libxkbfile-devel libudev-devel xorg-proto-devel

%description
evdev  is  an  Xorg  input  driver for Linux generic event devices.
It therefore supports all input devices that the kernel knows
about, including most mice and keyboards.

%package devel
Summary: Generic Linux input driver development package
Group: Development/C
Requires: %name = %version-%release

%description devel
Generic Linux input driver development package

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--with-xorg-module-dir=%_x11modulesdir \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_xconfdir
install -m644 *.conf %buildroot%_xconfdir/

%files
%config(noreplace) %_xconfdir/*.conf
%_x11modulesdir/input/*.so
%_xorgsysconfigdir/*.conf
%_man4dir/*

%files devel
%_includedir/*
%_pkgconfigdir/*.pc

%changelog
