Group: Development/Java
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-default
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xmlgraphics-commons
Version:        2.7
Release:        alt2_2jpp11
Epoch:          0
Summary:        XML Graphics Commons

License:        ASL 2.0
URL:            http://xmlgraphics.apache.org/
Source0:        http://archive.apache.org/dist/xmlgraphics/commons/source/xmlgraphics-commons-%{version}-src.tar.gz

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(commons-io:commons-io)
BuildRequires:  mvn(commons-logging:commons-logging)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.mockito:mockito-core)
BuildRequires:  mvn(xml-resolver:xml-resolver)
Source44: import.info

%description
Apache XML Graphics Commons is a library that consists of
several reusable components used by Apache Batik and
Apache FOP. Many of these components can easily be used
separately outside the domains of SVG and XSL-FO. You will
find components such as a PDF library, an RTF library,
Graphics2D implementations that let you generate PDF &
PostScript files, and much more.

%package javadoc
Group: Development/Java
Summary: Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains API documentation for %{name}.

%prep
%setup -q %{name}-%{version}

find -name "*.jar" -delete

# Disable plugins not needed for RPM build
%pom_remove_plugin :maven-checkstyle-plugin
%pom_remove_plugin :findbugs-maven-plugin

# Make into OSGi bundle
%pom_xpath_inject pom:project '<packaging>bundle</packaging>'
%pom_add_plugin org.apache.felix:maven-bundle-plugin . \
" <extensions>true</extensions>
  <configuration>
    <instructions>
      <Bundle-SymbolicName>org.apache.xmlgraphics</Bundle-SymbolicName>
    </instructions>
  </configuration>"

%build
%mvn_file : %{name}
%mvn_build -f -- -Dmaven.compiler.source=1.8 -Dmaven.compiler.target=1.8 -Dmaven.javadoc.source=1.8 -Dmaven.compiler.release=8

%install
%mvn_install

%files -f .mfiles
%doc --no-dereference LICENSE NOTICE
%doc README

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
