%define _unpackaged_files_terminate_build 1

Name: xli
Version: 1.17.0
Release: alt10
Summary: X11 Image Loading Utility
License: MIT
Group: Graphics

Url: http://pantransit.reptiles.org/prog
# had to repackage
# %url/%name-%version.tar.bz2
Source: %name-%version.tar

Patch1: xli-1.17.0-mdk-path.patch

# Patches from Debian (xli 1.17.0+20061110-10)
Patch9:  030-manpage.patch
Patch10: 040-8-bit_palette_support.patch
Patch11: 050-read_past_bufferend_343718.patch
Patch12: 060-security_fixes.patch
Patch13: 080-fillscreen_forall.patch
Patch14: 090-multiple_images_merge.patch
Patch15: 100-xpm_background.patch
Patch16: 110-arrow_keys.patch
Patch17: 120-documentzooming.patch
Patch18: 130-zoom_auto_440768.patch
Patch19: 140-manpage_fixes.patch
Patch20: 150-fix-x-resource-leak.patch
Patch21: 160-disable-libjpeg-scaling.patch
Patch22: 170-fix-spelling.patch
Patch23: 180-add_GCC_hardening.patch
Patch24: 190.added-directive.patch
Patch25: 200.fix-assertion-image.patch
Patch26: 210.fix-geometry-with-negative.patch
Patch27: 220.fix-tgas-with-alpha.patch
Patch28: 230.fix-buffer-overflow.patch

Provides: xloadimage
Obsoletes: xloadimage

# Automatically added by buildreq on Mon Dec 01 2008
BuildRequires: gccmakedep imake libX11-devel libXext-devel libjpeg-devel libpng-devel xorg-cf-files

%description
This utility will view several types of images under X11, or load images
onto the X11 root window.
Can view the following image types under X11:
FBM Image, Sun Rasterfile, CMU WM Raster, Portable Bit Map (PBM, PGM,
PPM), Portable Network Graphics (PNG), Faces Project, GIF Image, JFIF
style jpeg Image, Utah RLE Image, Windows, OS/2 RLE Image, Photograph
on CD Image, X Window Dump, Targa Image, McIDAS areafile, G3 FAX Image,
PC Paintbrush Image, GEM Bit Image, MacPaint Image, X Pixmap, X Bitmap.

%prep
%setup
%patch1 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p2
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1

%build
%add_optflags -Werror=implicit-function-declaration
xmkmf -a
%make_build CFLAGS="%optflags"
for i in xli xlito; do
	install -pm644 $i.man $i.1
done
install -pm644 xliguide.man xliguide.5
install -pm644 mit.cpyrght COPYRIGHT

%install
mkdir -p %buildroot{%_x11bindir,%_x11mandir/man{1,5},%_sysconfdir/X11/app-defaults}
%make_install install \
	SYSPATHFILE="%buildroot%_sysconfdir/X11/app-defaults/Xli" \
	BINDIR="%buildroot%_x11bindir"

for n in 1 5; do
	for i in *.$n; do
		install -pm644 "$i" "%buildroot%_x11mandir/man$n/$i"
	done
done

ln -snf xli %buildroot%_x11bindir/xsetbg
ln -snf xli %buildroot%_x11bindir/xview

chmod 644 README*

%files
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%_x11bindir/*
%_x11mandir/man?/*
%doc chkgamma.jpg README* ABOUTGAMMA COPYRIGHT

# TODO:
# - look at 2006-11-10 snapshot?

%changelog
