Name: xfdesktop
Version: 4.20.1
Release: alt2

Summary: Desktop manager for the Xfce Desktop Environment
Summary (ru_RU.UTF-8): Менеджер рабочего стола Xfce
# Backgrounds licensed as CC-BY-SA-4.0
License: GPLv2+ and CC-BY-SA-4.0
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/xfdesktop/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfdesktop.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-xfce4 >= 0.2.0-alt1 xfce4-dev-tools
BuildRequires: libthunar-devel libgarcon-devel libgarcon-gtk3-devel libxfce4panel-gtk3-devel libexo-gtk3-devel libxfce4ui-gtk3-devel
BuildRequires: libxfconf-devel >= 4.19.3
BuildRequires: libxfce4windowing-devel >= 4.19.8
BuildRequires: libX11-devel
BuildRequires: libgtk-layer-shell-devel
Buildrequires: time
BuildRequires: libnotify-devel
BuildRequires: libyaml-devel

Requires: exo-utils

# libxfce4windowing >= 4.19.6 breaks API/ABI whithout soname change
Conflicts: libxfce4windowing < 4.19.6

%define _unpackaged_files_terminate_build 1

%define default_background %_datadir/backgrounds/xfce/default-background

%description
%name contains a desktop manager for the Xfce Desktop Environment.

%description -l ru_RU.UTF-8
Данный пакет содержит в себе менеджер рабочего стола для окружения Xfce.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-x11 \
	--enable-wayland \
	--enable-notifications \
	--enable-thunarx \
	--enable-desktop-icons \
	--enable-file-icons \
	--with-default-backdrop-filename=%default_background \
	--enable-debug=minimum

%make_build

%install
%makeinstall_std
%find_lang %name

touch %buildroot%default_background

%post
# Set default Xfce background
if ! [ -L %default_background ]; then
	ln -s xfce-x.svg %default_background ||:
fi

%files -f %name.lang
%doc README.md NEWS AUTHORS doc/README.*
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_mandir/man?/*
%_datadir/backgrounds/xfce
%ghost %default_background

%changelog
