Name: xfce4-places-plugin
Version: 1.9.0
Release: alt1

Summary: This plugin is a menu with quick access to folders, documents, and removable media
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/xfce4-places-plugin/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-places-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel libxfce4util-devel libexo-gtk3-devel
BuildRequires: libxfconf-devel
BuildRequires: libgio-devel libnotify-devel

Requires: xfce4-panel >= 4.16

%define _unpackaged_files_terminate_build 1

%description
This xfce4-places-plugin brings much of the functionality of GNOME's
Places menu to Xfce.
The plugin looks a lot like a launcher with multiple items in a menu.
The main "launcher" button opens up Thunar at the user's home directory.
The arrow button opens up a menu with two sections: system-defined
locations and user-defined locations.
The system-defined locations are consistent with Thunar (including their
icons).
For user-defined bookmarks, the plugin reads the ~/.gtk-bookmarks file
so that it shares bookmarks with Thunar, Nautilus, the GNOME Panel, etc.

%prep
%setup
%patch -p1

%build
%meson \
	-Dlibnotify=enabled
%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README.md AUTHORS NEWS
%_bindir/xfce4-popup-places
%_libdir/xfce4/panel/plugins/*
%_datadir/xfce4/panel/plugins/*.desktop

%changelog
