Name: xfce4-mixer
Version: 4.20.0
Release: alt1

Summary: A volume control application and plugin for the Xfce panel
License: GPL-2.0+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/apps/xfce4-mixer/start
Packager: Xfce Team <xfce@packages.altlinux.org>
Vcs: https://gitlab.xfce.org/apps/xfce4-mixer.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires: rpm-build-xfce4 xfce4-dev-tools >= 0.1.1-alt1
BuildRequires: libxfce4ui-gtk3-devel libxfce4util-devel libxfconf-devel
BuildRequires: libxfce4panel-gtk3-devel >= 4.14.0
BuildRequires: gstreamer1.0-devel libkeybinder3-devel
BuildRequires: libpulseaudio-devel libalsa-devel

Requires: xfce4-panel

%define _unpackaged_files_terminate_build 1

%description
This package contains a volume control application based on GStreamer written
to conceptually fit into the Xfce desktop environment. It includes a plugin for
the Xfce panel.

%prep
%setup
%patch -p1

%build
%meson \
	-Dkeybinder=enabled \
	-Dpulse=enabled \
	-Doss=disabled \
	-Dalsa=enabled \
	-Dsndio=disabled

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README AUTHORS NEWS
%_bindir/*
%_libdir/xfce4/panel/plugins/*
%_desktopdir/*
%_datadir/xfce4/mixer/
%_xfce4data/panel/plugins/*.desktop
%_man1dir/*

%changelog
