%ifndef _userunitdir
%define _userunitdir %_prefix/lib/systemd/user
%endif

Name: xdg-user-dirs
Version: 0.18
Release: alt2
Summary: Handles user special directories
Group: Graphical desktop/Other
License: GPLv2+ and MIT
Url: http://freedesktop.org/wiki/Software/xdg-user-dirs

Source0: http://user-dirs.freedesktop.org/releases/%name-%version.tar.gz
Source1: xdg-user-dirs.sh
Source2: xdg-user-dirs.control
Source10: xdg-user-dirs.service
Patch1: user-dirs-fix-encoding-0.13-alt.patch
Patch2: xdg-user-dirs-0.14-alt-home.patch
Patch3: user-dirs-update-fix-0.13-alt.patch

BuildRequires: xsltproc docbook-style-xsl

%description
Contains xdg-user-dirs-update that updates folders in a users
homedirectory based on the defaults configured by the administrator.

%prep
%setup
%patch1 -p2
%patch2 -p1

%build
%autoreconf
%configure
%make_build

%install
%make DESTDIR=%buildroot install
mkdir -p %buildroot%_x11sysconfdir/profile.d
mkdir -p %buildroot%_controldir/
mkdir -p %buildroot%_controldir/
mkdir -p %buildroot%_userunitdir/
install -p -m 755 %SOURCE1 %buildroot%_x11sysconfdir/profile.d
install -p -m 755 %SOURCE2 %buildroot%_controldir/xdg-user-dirs
install -p -m 0644 %SOURCE10 %buildroot/%_userunitdir/xdg-user-dirs.service
%find_lang %name

%post
%post_control -s disabled xdg-user-dirs
SYSTEMCTL=systemctl
if [ $1 = 1 ] && "$SYSTEMCTL" --version >/dev/null 2>&1; then
    $SYSTEMCTL -q --global enable %name.service >/dev/null 2>&1 || :
fi

%pre
%pre_control xdg-user-dirs

%preun
SYSTEMCTL=systemctl
if [ $1 = 0 ] && "$SYSTEMCTL" --version >/dev/null 2>&1; then
    $SYSTEMCTL -q --global disable %name.service >/dev/null 2>&1 || :
fi

%triggerin -- %name < 0.18-alt2
SYSTEMCTL=systemctl
if "$SYSTEMCTL" --version >/dev/null 2>&1; then
    $SYSTEMCTL -q --global enable %name.service >/dev/null 2>&1 || :
fi

%files -f %name.lang
%doc NEWS AUTHORS README
%_bindir/*
%config(noreplace) %_sysconfdir/xdg/user-dirs.conf
%config(noreplace) %_sysconfdir/xdg/user-dirs.defaults
%_x11sysconfdir/profile.d/*
%_userunitdir/xdg-user-dirs.service
%_controldir/*
%_man1dir/*user-dir*
%_man5dir/*user-dir*

%changelog
