%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 49
%define beta %nil

%def_enable check

Name: xdg-desktop-portal-gnome
Version: %ver_major.0
Release: alt1%beta

Summary: GNOME Desktop Portal
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Url: https://gitlab.gnome.org/GNOME/xdg-desktop-portal-gnome

Vcs: https://gitlab.gnome.org/GNOME/xdg-desktop-portal-gnome.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define xdg_desktop_portal_ver 1.19.1
%define adw_ver 1.7
%define gsds_ver 47

Requires: xdg-desktop-portal-gtk >= 1.14
Conflicts: xdg-desktop-portal-gtk < 1.12.0

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson libgtk4-devel pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(gnome-desktop-4)
BuildRequires: pkgconfig(xdg-desktop-portal) >= %xdg_desktop_portal_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver

%description
XDG Desktop Portal implementation for GNOME. It uses GNOME-specific APIs
and components, such as GNOME Shell, Mutter, and GNOME Settings Daemon,
to provide various portal features.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_libexecdir/%name
%_desktopdir/%name.desktop
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.gnome.service
%_datadir/xdg-desktop-portal/portals/gnome.portal
%_datadir/glib-2.0/schemas/%name.gschema.xml
%_userunitdir/%name.service
%doc NEWS README*


%changelog
