%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: xapian-omega
Version: 1.4.29
Release: alt1

Summary: A CGI search frontend and indexers built on Xapian
License: GPL-2.0-or-later
Group: Networking/WWW

Url: http://www.xapian.org
Source: http://www.oligarchy.co.uk/xapian/%version/%name-%version.tar.bz2

BuildRequires: gcc-c++
BuildRequires: libmagic-devel
BuildRequires: libpcre2-devel
BuildRequires: libxapian-devel = %version
BuildRequires: perl-DBI
BuildRequires: zlib-devel

Requires: xapian-core >= %version

%description
Omega is a CGI application which uses the Xapian Information Retrieval
library to index and search collections of documents.

%prep
%setup
%ifarch %e2k
# unsupported as of lcc 1.23.12
sed -i 's, -fno-gnu-keywords,,' configure*
%endif

%build
%configure
%make_build

%install
%makeinstall_std

# CGI application
mkdir -p %buildroot%_var/www/cgi-bin/
mv %buildroot%_libdir/%name/bin/omega %buildroot%_var/www/cgi-bin

# Create /var directories
mkdir -p %buildroot%_localstatedir/omega/{cdb,data}
mkdir -p %buildroot%_logdir/omega

# Default templates
mkdir -p %buildroot%_localstatedir/omega/templates
cp -a templates/* %buildroot%_localstatedir/omega/templates/

# Images
mkdir -p %buildroot%_var/www/icons/omega
cp -a images/* %buildroot%_var/www/icons/omega/

rm -rf %buildroot%_docdir/%name/

%files
%doc AUTHORS ChangeLog README TODO NEWS docs/*.html
%_bindir/dbi2omega
%_bindir/omindex
%_bindir/omindex-list
%_bindir/scriptindex
%_bindir/htdig2omega
%_bindir/mbox2omega
%_libdir/%name

%dir %_datadir/omega
%_datadir/omega/*.script

%_localstatedir/omega
%_logdir/omega/

%_var/www/cgi-bin/omega
%dir %_var/www/icons/omega
%_var/www/icons/omega/*.png

%config(noreplace) %_sysconfdir/omega.conf
%_man1dir/omindex.1*
%_man1dir/omindex-list.1*
%_man1dir/scriptindex.1*

%changelog
