%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: xapian-core
Version: 1.4.29
Release: alt1
%define sover 30
Summary: Xapian is an open source search engine library
License: GPL-2.0-or-later
Group: Development/Databases
Url: http://www.xapian.org
Vcs: https://github.com/xapian/xapian/

Source: http://www.oligarchy.co.uk/xapian/%version/%{name}-%{version}.tar
Source100: %name.watch

BuildRequires: gcc-c++
BuildRequires: libuuid-devel
BuildRequires: zlib-devel

%description
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

This is core package.

%package -n libxapian%sover
Summary: Xapian search engine libraries
Group: System/Libraries
Obsoletes: libxapian < %EVR

%description -n libxapian%sover
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models and
also supports a rich set of boolean query operators.

This package provides the libraries for applications using Xapian
functionality.

%package -n libxapian-devel
Group: Development/C++
Summary: Files needed for building packages which use Xapian
Requires: libxapian%sover = %EVR

%description -n libxapian-devel
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models and
also supports a rich set of boolean query operators.

This package provides the files needed for building packages which
use Xapian library.

%package -n %name-doc
Group: Development/Documentation
Summary: Developer's documentation for Xapian
Obsoletes: xapian-doc < 0.9.9
Provides: xapian-doc = %EVR
BuildArch: noarch

%description -n %name-doc
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models and
also supports a rich set of boolean query operators.

This package contains API reference in HTML and PostScript.

%prep
%setup
%autopatch
%ifarch %e2k
# current lcc doesn't know these
sed -i  -e 's,-fno-gnu-keywords,,;s,-Wstrict-null-sentinel,,' \
	-e 's,-Wstrict-overflow=1,,;s,-Wlogical-op,,;s,-Wdouble-promotion,,' \
	configure.ac
# http://stackoverflow.com/questions/14892101/
%add_optflags -ftls-model=global-dynamic
%endif

%build
%define optflags_lto %nil
%ifarch %ix86
%add_optflags -ffloat-store
%endif
%autoreconf
%configure \
%ifarch %ix86
	--disable-sse
%endif

%make_build
gzip -9nf ChangeLog

%install
%makeinstall_std
rm -rf %buildroot%_datadir/doc/xapian-core/

%check
unset MAKEFLAGS
time %make_build check

%files
%_bindir/copydatabase
%_bindir/quest
%_bindir/simpleexpand
%_bindir/simpleindex
%_bindir/simplesearch
%_bindir/xapian-check
%_bindir/xapian-compact
%_bindir/xapian-delve
%_bindir/xapian-metadata
%_bindir/xapian-pos
%_bindir/xapian-progsrv
%_bindir/xapian-replicate
%_bindir/xapian-replicate-server
%_bindir/xapian-tcpsrv
%_datadir/xapian-core/
%_man1dir/*.1*
%exclude %_man1dir/xapian-config.1*
%doc AUTHORS ChangeLog* NEWS PLATFORMS README

%files -n libxapian%sover
%_libdir/*.so.%sover
%_libdir/*.so.%sover.*

%files -n libxapian-devel
%_bindir/xapian-config
%_includedir/xapian.h
%_includedir/xapian/
%_libdir/libxapian.so
%_libdir/cmake/xapian/
%_datadir/aclocal/xapian.m4
%_man1dir/xapian-config.1*
%_pkgconfigdir/*.pc

%files -n %name-doc
%doc docs/*.html
%doc docs/apidoc/html/
%doc HACKING

%changelog
