%undefine __cmake_in_source_build
Name: wxMaxima
Version: 25.04.0
Release: alt1

Summary: GUI for the computer algebra system Maxima
License: GPL-2.0+
Group: Sciences/Mathematics

Url: https://wxmaxima-developers.github.io/wxmaxima

Source0: %name-%version.tar
Source5: wxmaxima-ru.po.bz2
Patch:   %name-alt-help-path.patch

Requires: maxima

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-ninja
BuildRequires: gcc-c++
BuildRequires: ccache
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: libgomp-devel
BuildRequires: libpango-devel
BuildRequires: libwxGTK3.2-devel
BuildRequires: libxml2-devel
BuildRequires: makeinfo
BuildRequires: po4a doxygen
BuildRequires: zlib-devel
BuildRequires: dos2unix
BuildRequires: GraphicsMagick

ExcludeArch: ppc64le

Provides: wxmaxima = %EVR
Obsoletes: wxmaxima < %EVR

%description
wxMaxima is a wxWidgets GUI for the computer algebra system Maxima.

Since it is written with wxWidgets, it runs on multiple platforms
in native widget sets.  Most of maxima functions are accessible through
menus, some have dialogs.  The input line has command history (up-key,
down-key) and completion based on previous input (tab-key).
wxMaxima provides 2d formated display of maxima output.


%prep
%setup
#  -n wxmaxima-Version-%{version} -p1
#bzcat %SOURCE5 >locales/wxMaxima/ru.po
#patch -p1
%ifarch %e2k
sed -i "/std::unique_ptr<T>() &&/{P;s/&&/\&/}" src/cells/CellList.h
%endif
dos2unix data/io.github.wxmaxima_developers.wxMaxima.desktop
%build

%cmake
%cmake_build

#
mkdir -p %buildroot%_datadir/wxmaxima

%install
%cmake_install


# app icon
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/{scalable,48x48,64x64,128x128}/apps/
cp -alf \
  %{buildroot}%{_datadir}/pixmaps/io.github.wxmaxima_developers.wxMaxima.svg \
  %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/
cp -alf \
  %{buildroot}%{_datadir}/pixmaps/io.github.wxmaxima_developers.wxMaxima.png \
  %{buildroot}%{_datadir}/icons/hicolor/128x128/apps/
gm convert -resize 64x64 \
  %{buildroot}%{_datadir}/icons/hicolor/128x128/apps/io.github.wxmaxima_developers.wxMaxima.png \
  %{buildroot}%{_datadir}/icons/hicolor/64x64/apps/io.github.wxmaxima_developers.wxMaxima.png
gm convert -resize 48x48 \
  %{buildroot}%{_datadir}/icons/hicolor/128x128/apps/io.github.wxmaxima_developers.wxMaxima.png \
  %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/io.github.wxmaxima_developers.wxMaxima.png


# icons
install -pD -m644 data/wxmaxima-16.xpm %buildroot%_miconsdir/%name.xpm
install -pD -m644 data/wxmaxima-32.xpm %buildroot%_niconsdir/%name.xpm
%find_lang %name

%files -f %name.lang
%doc AUTHORS.md NEWS.md README.md
%_bindir/wxmaxima
%_desktopdir/*%name.desktop
%_niconsdir/%name.xpm
%_miconsdir/%name.xpm
%_datadir/icons/hicolor/*/*/*
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/bash-completion/completions/wxmaxima
%_datadir/mime/packages/x-wxmathml.xml
%_datadir/mime/packages/x-wxmaxima-batch.xml
%_docdir/wxmaxima/
%_man1dir/wxmaxima.1*
%_mandir/de/man1/wxmaxima.1*
%_pixmapsdir/*.xpm
%_pixmapsdir/*.png
%_pixmapsdir/*.svg
%_datadir/metainfo/*wxMaxima.appdata.xml

%changelog
