Name: wv
Version: 1.2.9
Release: alt2

%def_disable static

Summary: MSWord 6/7/8/9 binary file -> open format converters
License: GPL
Group: Office

Url: http://wvware.sf.net/
Source: http://prdownloads.sourceforge.net/wvware/%name-%version.tar.bz2

# Automatically added by buildreq on Fri Oct 14 2005
BuildRequires: common-licenses glib2-devel libgsf-devel libpng-devel libxml2-devel pkg-config zlib-devel
# Manually removed: gcc-c++ libstdc++-devel

Requires: lib%name = %version-%release
Obsoletes: mswordview

%package print
Summary: MSWord 6/7/8/9 binary file -> open format converters (print friendly)
Group: Office
Requires: %name = %version-%release
Provides: wv-tetex
Obsoletes: wv-tetex

%package -n lib%name
Summary: MSWord 6/7/8/9 binary file -> open format converters (shared library)
Group: Office

%package -n lib%name-devel
Summary: MSWord 6/7/8/9 binary file -> open format converters (development)
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel
Obsoletes: %name-devel

%if_enabled static
%package -n lib%name-devel-static
Summary: MSWord 6/7/8/9 binary file -> open format converters (static libraries)
Group: Development/C
Requires: lib%name-devel = %version-%release
%endif	# enabled static

%description
Wv is a family of programs that understand the Microsoft Word 6/7/8/9
binary file format and are able to convert Word
documents into various open formats.

%description print
Tetex-dependent converters for Microsoft Word 6/7/8/9 from the Wv family.
These can convert Word documents into DVI, PostScript and PDF.

%description -n lib%name
Wv is a family of programs that understand the Microsoft Word 6/7/8/9
binary file format and are able to convert Word
documents into various open formats.

This package contains libwv, the Wv shared library.

%description -n lib%name-devel
Wv is a family of programs that understand the Microsoft Word 6/7/8/9
binary file format and are able to convert Word
documents into various open formats.

This is the development package for libwv, the Wv shared library.

%if_enabled static
%description -n lib%name-devel-static
Wv is a family of programs that understand the Microsoft Word 6/7/8/9
binary file format and are able to convert Word
documents into various open formats.

This package contains the libwv.a static library.
%endif	# enabled static

%prep
%setup
cp -at . /usr/share/gnu-config/config.guess
rm -f COPYING
ln -s %_licensedir/GPL-2 COPYING

%build
sed -i 's@CFLAGS =@AM_CFLAGS =@' GNUmakefile.am
sed -i 's@CPPFLAGS =@AM_CPPFLAGS =@' GNUmakefile.am
./autogen.sh

%configure --disable-dependency-tracking \
    %{subst_enable static}

%make_build

%install
%makeinstall

%files
%doc --no-dereference COPYING
%doc README
%_bindir/wvAbw
%_bindir/wvCleanLatex
%_bindir/wvConvert
%_bindir/wvDocBook
%_bindir/wvHtml
%_bindir/wvLatex
%_bindir/wvRTF
%_bindir/wvSummary
%_bindir/wvText
%_bindir/wvVersion
%_bindir/wvWare
%_bindir/wvWml
%_datadir/wv
%_man1dir/wvAbw.1*
%_man1dir/wvCleanLatex.1*
%_man1dir/wvHtml.1*
%_man1dir/wvLatex.1*
%_man1dir/wvRTF.1*
%_man1dir/wvSummary.1*
%_man1dir/wvText.1*
%_man1dir/wvVersion.1*
%_man1dir/wvWare.1*
%_man1dir/wvWml.1*

%files print
%_bindir/wvDVI
%_bindir/wvMime
%_bindir/wvPDF
%_bindir/wvPS
%_man1dir/wvDVI.1*
%_man1dir/wvMime.1*
%_man1dir/wvPDF.1*
%_man1dir/wvPS.1*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
