%define _unpackaged_files_terminate_build 1
%if "%_vendor" == "alt"
# hack for lib.req: ERROR: /tmp/.private/lav/wine-etersoft-buildroot/usr/lib64/wine/x86_64-unix/ws2_32.so: library ntdll.so not found
%filter_from_requires /^ntdll.so.*/d
%filter_from_requires /^win32u.so.*/d
%global __find_debuginfo_files %nil
%endif

%def_without devel
%def_with vanilla
%define gecko_version 2.47.4
%define mono_version 10.3.0
%define winetricks_version 20250102

# https://dl.winehq.org/wine/source/
%define basemajor 10.x
%define major 10.17
%define rel %nil

# the packages will conflict with that
%define conflictlist wine wine-stable wine-tkg wine-proton-tkg wine-etersoft
%define wow64conflict i586-wine i586-wine-stable i586-wine-tkg i586-wine-proton-tkg

%define __add_conflict() \
for mod in %{conflictlist}; do \
    echo -n "$mod-%{*} "; \
done; unset mod;\
%nil

%define add_conflict() \
Conflicts: %(%{expand: %%__add_conflict %{*}}) \
%nil

# build ping subpackage
%def_with set_cap_net_raw

# build wow64 package (both 32/64 PE in the one package)
%def_with wow64

%ifarch aarch64
# old clang have some troubles with .seh on aarch64
# use at least llvm 15
%define min_llvm_ver 15
%else
%define min_llvm_ver 11
%endif

# used _llvm_version from rpm-macros-llvm-common
%if %{defined _llvm_version}
%define llvm_ver %(LANG=C printf %%.0f %{_llvm_version})
%else
%define llvm_ver 0
%endif

%if %llvm_ver < %min_llvm_ver
%global _llvm_version %min_llvm_ver.0
%define llvm_ver %min_llvm_ver
%endif

# use %min_llvm_ver instead of _llvm_version (feature version can be obsoleted)
%if_feature llvm %min_llvm_ver
# build real PE libraries (.dll, not .dll.so), via clang
%def_with mingw
%else
%def_without mingw
# can't build wow64 without PE
%undefine _with_wow64
%endif

%if_with wow64
%undefine _without_mingw
%def_with mingw
%endif

# build all project with clang
%def_without clang

# https://bugs.etersoft.ru/show_bug.cgi?id=15244
%def_with unwind

# keep debugging symbols in PE files (skip strip)
# TODO: check if we need debug info and pack it separately
%def_with debugpe

# use rpm-macros-features
%if_feature vulkan
    %def_with vulkan
%else
    %def_without vulkan
%endif

%if_feature wayland
    %def_with wayland
%else
    %def_without wayland
%endif

%if_feature ffmpeg
    %def_with ffmpeg
%else
    %def_without ffmpeg
%endif

%def_with sdl

%if_feature opencl
    %def_with opencl
%else
    %def_without opencl
%endif

%if_feature pcap 1.10.3
    %def_with pcap
%else
    %def_without pcap
    %def_without set_cap_net_raw
%endif

# default for unsupported arches
%define winepkgname wine-vanilla

%ifarch x86_64 aarch64
    %def_with build64
    %define winearch wine64
    %define winepkgname wine-vanilla
%endif

# workaround for https://bugzilla.altlinux.org/38130
# buildwow64 = _arch = x86_64  && with wow64
%if "%_arch" == "x86_64" && %{expand:%%{?_with_wow64:1}%%{!?_with_wow64:0}}
    %def_with buildwow64
    %undefine _with_build64
    %define winearch wine
%else
    %def_without buildwow64
%endif

%ifarch %ix86
    %def_without build64
    %define winearch wine32
    %define winepkgname wine-vanilla
%endif

Name: wine-vanilla
Version: %major
Release: alt2
Epoch: 1

Summary: Wine - environment for running Windows applications

License: LGPLv2+
Group: Emulators
Url: http://winehq.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://dl.winehq.org/wine/source/%basemajor/wine-%version%rel.tar.xz
Source: %name-%version.tar

Source3: %name-%version-desktop.tar
Source4: %name-%version-icons.tar
# multilib wrapper scripts
Source6: %name-%version-bin-scripts.tar

# local patches
#Source10: %name-patches-%version.tar

Patch1: 0011-build-fake-binary-makes-autoreq-happy.patch
Patch2: 0102-fix-build-on-32-bit-systems-with-llvm-https-bugs.win.patch
Patch3: 0017-configure-Work-around-install-sh-requirement-in-auto.patch

AutoReq: yes, noperl, nomingw32, nocpp

# build with clang on aarch64, as for Mac OS
%ifarch aarch64
%undefine _without_clang
%def_with clang
%endif

%if_with clang
# clang-12: error: unsupported argument 'auto' to option 'flto='
%define optflags_lto -flto=thin
%endif

# PE cross-compilation is required for ARM64
%if_with mingw
ExclusiveArch: %ix86 x86_64 aarch64
%else
ExclusiveArch: %ix86 x86_64
%endif

# minimalize memory using
%ifarch %ix86 armh
%define optflags_debug -g0
%define optflags_lto %nil
%endif


# disable LTO: link error in particular, and unverified in general
#x86_64-alt-linux-gcc -m64 -o loader/wine64-preloader loader/preloader.o loader/preloader_mac.o -static -nostartfiles -nodefaultlibs \
#  -Wl,-Ttext=0x7d400000
#ld: /usr/src/tmp/wine64-preloader.yxZ9KH.ltrans0.ltrans.o: in function `_start':
#<artificial>:(.text+0x12): undefined reference to `thread_data'
#ld: <artificial>:(.text+0x2a): undefined reference to `wld_start'
%define optflags_lto %nil

# used in paths
%define wineproduct wine
%define libdir %_libdir
%define libwinedir %libdir/%wineproduct
%define winebindir %_libexecdir/%wineproduct
%if_with build64
    %define wineserver wineserver64
    %define winebin wine64
%endif
%if_with buildwow64
    %define wineserver wineserver64
    %define winebin wine64
%endif
%if_without build64
    %define wineserver wineserver32
    %define winebin wine32
%endif

%define winepedir unsupported-windows
%define winesodir unsupported-unix

%define winepe32dir i386-windows
%define winepe64dir %_arch-windows

# set arch dependent dirs
%ifarch %{ix86}
%define winepedir i386-windows
%define winesodir i386-unix
%endif
%ifarch x86_64
%define winepedir x86_64-windows
%define winesodir x86_64-unix
%define wow64_arches i386,x86_64
%endif
%ifarch %{arm}
%define winepedir arm-windows
%define winesodir arm-unix
%endif
%ifarch aarch64
%define winepedir aarch64-windows
%define winesodir aarch64-unix
%endif


%if_without build64
    # skip -fPIC checking (-fnoPIC need in new wine to skip DECLSPEC_HOTPATCH)
    %add_verify_elf_skiplist %libwinedir/%winesodir/*.so
    # -fPIC is totally disabled for i586
    %add_verify_elf_skiplist %_bindir/*
    %add_verify_elf_skiplist %winebindir/*
%endif

# TODO: remove it for mingw build (when there will no any dll.so files)
%add_verify_elf_skiplist %libwinedir/%winesodir/*.*.so
%add_findreq_skiplist %libwinedir/%winepe32dir/*
%add_findreq_skiplist %libwinedir/%winepe64dir/*

#
# /usr/bin/strip: ./usr/lib64/wine/x86_64-windows/stqrTIUz/stPNVRry/dsound.dll: warning: line number count (0x10000) exceeds section size (0x8)
# /usr/bin/strip: ./usr/lib64/wine/x86_64-windows/stbguFIA: file format not recognized
# see also our strip below
%if_with debugpe
%global __os_install_post %{nil}
%brp_strip_none %libwinedir/%winepe32dir/*
%brp_strip_none %libwinedir/%winepe64dir/*
%endif

# we don't need provide anything
AutoProv:no

# for wine-staging gitapply.sh script
BuildRequires: /proc

# used llvm/clang toolchain if needed
%if "%_vendor" == "alt" && %{defined _llvm_version}
%define llvm_br clang%_llvm_version llvm%_llvm_version lld%_llvm_version
%else
# just use default llvm
%define llvm_br clang llvm lld
%endif

%if_with clang
BuildRequires: %llvm_br
%else
BuildRequires: gcc
%endif

%if_with mingw
BuildRequires: %llvm_br
%endif

# General dependencies
BuildRequires(pre): rpm-build-intro >= 2.1.14
BuildRequires(pre): rpm-macros-features
%if "%_vendor" == "alt"
BuildRequires(pre): rpm-macros-llvm-common
%endif
BuildRequires: util-linux flex bison
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libattr-devel
BuildRequires: libgphoto2-devel libsane-devel libcups-devel
BuildRequires: libv4l-devel
BuildRequires: libalsa-devel jackit-devel libpulseaudio-devel
BuildRequires: libGLU-devel
%if_with sdl
BuildRequires: libSDL2-devel
%endif
%if_with wayland
BuildRequires: libwayland-client-devel libglvnd-devel libwayland-egl-devel libxkbcommon-devel
%endif
%if_with ffmpeg
BuildRequires: libavutil-devel libavformat-devel libavcodec-devel
%endif

BuildRequires: libusb-devel libieee1284-devel
BuildRequires: libgcrypt-devel libgnutls-devel libsasl2-devel libkrb5-devel
BuildRequires: libunixODBC-devel
%if_with pcap
BuildRequires: libpcap-devel
%endif
BuildRequires: valgrind-devel
%if_with unwind
BuildRequires: libunwind-devel
%endif

# dlls/netapi32
#BuildRequires: libnetapi-devel
BuildRequires: pkgconfig(netapi)

#BuildRequires: gstreamer-devel gst-plugins-devel

# for winscard (libpcsclite.so here)
BuildRequires: libpcsclite-devel

%if_with vulkan
BuildRequires: libvulkan-devel
%endif

%if_with opencl
BuildRequires: ocl-icd-devel opencl-headers
%endif

# Staging part
%if_with gtk3
# GTK3 theme support: staging only
BuildRequires: libgtk+3-devel libcairo-devel
%endif
BuildRequires: libva-devel

# udev needed for udev version detect
BuildRequires: libudev-devel udev libdbus-devel

# all Xorg dependencies
BuildRequires: libxcb-devel
BuildRequires: libICE-devel libSM-devel
BuildRequires: libX11-devel libXau-devel libXaw-devel libXrandr-devel
BuildRequires: libXext-devel libXfixes-devel libXfont-devel libXft-devel libXi-devel
BuildRequires: libXmu-devel libXpm-devel libXrender-devel
BuildRequires: libXres-devel libXScrnSaver-devel libXinerama-devel libXt-devel
BuildRequires: libXxf86dga-devel libXcomposite-devel
BuildRequires: libXxf86vm-devel libfontenc-devel libXdamage-devel
BuildRequires: libXvMC-devel libXcursor-devel libXv-devel

# a long way to get needed perl-XML-LibXML?
BuildRequires: perl-XML-Simple

BuildRequires: desktop-file-utils

#BuildRequires(pre): rpm-macros-wine

# Use it instead proprietary MS Core Fonts
# Requires: fonts-ttf-liberation

# FIXME: Actually for x86_32
Requires: glibc-pthread glibc-nss

#Requires: %name-gecko = %gecko_version

# For menu/MIME subsystem
Requires: desktop-file-utils

Requires: %name-common = %EVR

# ALT bug #55444
# wine will ask anyway
Requires: wine-mono = %mono_version
Requires: wine-gecko = %gecko_version

%if_with buildwow64
Conflicts: %wow64conflict
%endif

Conflicts: %conflictlist

# old gl part
Provides: %winepkgname-gl = %EVR
Obsoletes: %winepkgname-gl < %EVR

Conflicts: libwine-vanilla-gl libwine-gl
Conflicts: wine-vanilla-gl wine-gl
Obsoletes: lib%name-gl < %EVR

# old twain part
Provides: %winepkgname-twain = %EVR
Obsoletes: %winepkgname-twain < %EVR

Conflicts: libwine-vanilla-twain libwine-twain
Conflicts: wine-vanilla-twain wine-twain
Obsoletes: lib%name-twain < %EVR

# Provides/Obsoletes Fedora packages
%define common_provobs wine-filesystem wine-desktop wine-systemd wine-sysvinit
%define base_provobs wine-alsa wine-capi wine-cms wine-ldap wine-openal wine-pulseaudio wine-wow wine-alsa wine-capi wine-cms wine-ldap wine-opencl wine-pulseaudio
%define fonts_provobs wine-fonts wine-arial-fonts wine-courier-fonts wine-fixedsys-fonts wine-marlett-fonts wine-ms-sans-serif-fonts wine-small-fonts wine-symbol-fonts wine-system-fonts wine-tahoma-fonts wine-times-new-roman-fonts wine-wingdings-fonts
#Provides: %common_provobs %base_provobs %fonts_provobs
Obsoletes: %common_provobs %base_provobs %fonts_provobs


#=========================================================================

%description
Wine (originally an acronym for "Wine Is Not an Emulator")
is a compatibility layer capable of running Windows applications.
Instead of simulating internal Windows logic like a virtual machine or emulator,
Wine translates Windows API calls into POSIX calls on-the-fly,
eliminating the performance and memory penalties
of other methods and allowing you to cleanly integrate Windows applications into your desktop.

This build uses only winehq upstream sources without any patches.

%package test
Summary: WinAPI test for Wine
Summary(ru_RU.UTF-8): Тест WinAPI для Wine
Group: Emulators
Requires: %name = %EVR
%add_conflict test

%description test
WinAPI test for Wine (unneeded for usual work).
Warning: it may kill your X server suddenly.


%package full
Summary: Wine meta package
Summary(ru_RU.UTF-8): Мета пакет Wine
Group: Emulators
# due ExclusiveArch
#BuildArch: noarch
Requires: %name = %EVR
Requires: %name-programs = %EVR

Requires: winetricks >= %winetricks_version

%add_conflict full

%description full
Wine meta package. Use it for install all wine subpackages.


%package common
Summary: Common wine files and scripts
Summary(ru_RU.UTF-8): Общие файлы и скрипты Wine
Group: Emulators
BuildArch: noarch
%add_conflict common
# we don't need provide anything
AutoProv:no
Conflicts: libwine <= 6.14.1
Conflicts: i586-libwine <= 6.14.1
Conflicts: wine <= 6.14.1
Conflicts: i586-wine <= 6.14.1

Conflicts: libwine-vanilla <= 6.14.1
Conflicts: i586-libwine-vanilla <= 6.14.1
Conflicts: wine-vanilla <= 6.14.1
Conflicts: i586-wine-vanilla <= 6.14.1

Requires: %name = %EVR

%description common
Common arch independent wine files and scripts.

%description common -l ru_RU.UTF-8
Общие архитектурно-независимые файлы Wine.


%package programs
Summary: Wine programs
Group: Emulators
Requires: %name = %EVR
# due ExclusiveArch
#BuildArch: noarch

%add_conflict programs

%description programs
Wine GUI programs:
 * winefile
 * notepad
 * winemine


%package ping
Summary: Set capability for Wine ping
Group: Emulators
Requires: %name = %EVR
# due ExclusiveArch
#BuildArch: noarch
%add_conflict ping

%if_with set_cap_net_raw
Requires(pre): libcap-utils
%endif


%description ping
Set capability for Wine ping in post install script.

Also you can control in manually:

$ wine-cap_net_raw [on|off]


%package devel-tools
Summary: Development tools for %name-devel
Group: Development/C
Requires: %name-devel = %EVR
%add_conflict devel-tools
Conflicts: lib%name-devel < %version
%if_with devel
Provides: libwine-devel = %EVR
%endif
# we don't need provide anything
AutoProv:no

# winegcc requires
Requires: glibc-devel libstdc++-devel

%if_with clang
Requires: %llvm_br
%else
Requires: gcc gcc-c++
%endif

%if_with mingw
Requires: %llvm_br
%endif

%description devel-tools
%name-devel-tools contains tools needed to
develop programs using %name.

%description devel-tools -l ru_RU.UTF-8
%name-devel содержит файлы для разработки программ,
использующих Wine: заголовочные файлы и утилиты,
предназначенные для компилирования программ с %name.


%package devel
Summary: Headers for %name-devel
Group: Development/C
Requires: %name = %EVR
Obsoletes: lib%name-devel < %version
#Provides: lib%name-devel = %EVR
%add_conflict devel
# we don't need provide anything
AutoProv:no


%description devel
%name-devel contains the header files and some utilities needed to
develop programs using %name.

%description devel -l ru_RU.UTF-8
%name-devel содержит файлы для разработки программ, использующих Wine:
заголовочные файлы и утилиты, предназначенные
для компилирования программ с %name.


%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
# Apply local patches
#name-patches/patchapply.sh

%build
%if_with clang
%remove_optflags -frecord-gcc-switches
export CC=clang-%llvm_ver
# not supported
#export CPP=clang-cpp-%llvm_ver
export LD=lld-%llvm_ver
%endif

# disable fortify as it can breaks wine
# http://bugs.winehq.org/show_bug.cgi?id=24606
%remove_optflags -fcf-protection
%remove_optflags -fstack-protector-strong
%remove_optflags -fstack-clash-protection
# drop default FORTIFY_SOURCE here to mute warning when overrides with _FORTIFY_SOURCE=0 (wine disable it)
%remove_optflags -Wp,-D_FORTIFY_SOURCE=2
%remove_optflags -D_FORTIFY_SOURCE=2

%if_without buildwow64
echo "Needed llvm %_llvm_version is not present on the build platform, build without wow64 support."
%endif

%configure --with-x \
	--disable-win16 \
%if_with build64
	--enable-win64 \
%endif
%if_with buildwow64
	--enable-archs=%wow64_arches \
%endif
	--disable-tests \
	--without-gstreamer \
	--without-oss --with-alsa --with-pulse \
	--with-cups \
	--without-capi \
	%{subst_with opencl} \
	%{subst_with pcap} \
%if_with mingw
	--with-mingw=%llvm_bindir/clang \
%endif
	%{subst_with vulkan} \
	%{subst_with sdl} \
	%{subst_with wayland} \
	%{subst_with ffmpeg} \
	--bindir=%winebindir \
	%nil

%__make depend
%make_build


%install
%makeinstall_std

# clean permissions (via find to hide file list)
find %buildroot%libwinedir/%winesodir -type f | xargs chmod 0644
find %buildroot%libwinedir/%winepedir -type f | xargs chmod 0644

# hack for lib.req: ERROR: /tmp/.private/lav/wine-etersoft-buildroot/usr/lib64/wine/x86_64-unix/ws2_32.so: library ntdll.so not found
cp -v %buildroot%libwinedir/%winesodir/ntdll.so %buildroot%libdir
cp -v %buildroot%libwinedir/%winesodir/win32u.so %buildroot%libdir

mkdir -p %buildroot%_bindir/

mv -v %buildroot%winebindir/wine %buildroot%winebindir/%winebin

# hack: move all programs back to _bindir
find %buildroot%winebindir -mindepth 0 -maxdepth 1 -not -type d | \
    egrep -v '/wine$|/wine32$|/wineserver$|/wineserver32$|/wine64$|/wineserver64|/winegcc|/wineg++|/winecpp|/winebuild$' | \
    xargs mv -v -t %buildroot%_bindir/
[ -s %buildroot%_bindir/wineg++ ] || ln -sv --relative %buildroot%winebindir/wineg++ %buildroot%_bindir/
[ -s %buildroot%_bindir/winecpp ] || ln -sv --relative %buildroot%winebindir/winecpp %buildroot%_bindir/


# FIXME: it is missed on 64 bit (it is supposed to be installed with wine 32)
%if_with build64
install -p -m 0644 tools/wine/wine.man %buildroot%_man1dir/wine.1
%endif

# unpack desktop files
cd %buildroot%_desktopdir/
tar xvf %SOURCE3
mkdir -p %buildroot%_datadir/desktop-directories/
mv *.directory %buildroot%_datadir/desktop-directories/
cd - >/dev/null

# unpack icons files
mkdir -p %buildroot%_iconsdir/
cd %buildroot%_iconsdir/
tar xvf %SOURCE4
cd - >/dev/null

# unpack bin scripts files
mkdir -p %buildroot%_bindir/
tar xvf %SOURCE6
for i in bin-scripts/*.in ; do
    tbin=%buildroot%_bindir/$(basename $i .in)
    sed -e "s:@BINDIR@:%winebindir:g" -e "s:@DATADIR@:%_datadir/%wineproduct:g" -e "s:@LIBDIR@:%_libdir:g" -e "s:@WINELIBDIR@:%_libdir/%wineproduct:g" -e "s:@WINELIB32DIR@:%_lib32dir/%wineproduct:g"    $i > $tbin
    chmod +x $tbin
done

%if "%wineserver" != "wineserver"
mv -v %buildroot%winebindir/wineserver %buildroot%winebindir/%wineserver
cp %buildroot%_bindir/wineserver %buildroot%winebindir/wineserver
%endif

%if_with build64
[ -s %buildroot%_bindir/wine64 ] || ln -sv --relative %buildroot%winebindir/wine64 %buildroot%_bindir/
%endif

chmod a+x %buildroot%libwinedir/%winesodir/{wine,wine-preloader,wine_make_autoreq_happy}

%if_with set_cap_net_raw
# script for %name-ping
mkdir -p %buildroot%_sbindir/
mv %buildroot%_bindir/wine-cap_net_raw %buildroot%_sbindir/
%endif

# Do not pack non english man pages yet
rm -rv %buildroot%_mandir/*.UTF-8

# Do not pack dangerous association to run windows executables
rm -v %buildroot%_desktopdir/wine.desktop

%if_without debugpe
# [aarch64] /usr/bin/strip: /usr/src/tmp/wine-staging-buildroot/usr/lib64/wine/aarch64-windows/xinput1_1.dll: file format not recognized
%ifarch aarch64
# /usr/src/tmp/wine-staging-buildroot/usr/lib64/wine/aarch64-windows/xpssvcs.dll
# [aarch64] llvm-strip: error: unsupported object file format
llvm-strip %buildroot%libwinedir/%winepedir/* || :
%else
strip %buildroot%libwinedir/%winepedir/*
%endif
# fix against old broken strip: restore builtin mark
tools/winebuild/winebuild --builtin %buildroot%libwinedir/%winepedir/*
%endif


%if_with set_cap_net_raw
%files ping
%_sbindir/wine-cap_net_raw
%endif

%files
%if_with build64
%_bindir/wine64
%endif
%winebindir/%winebin
%winebindir/%wineserver

%dir %libwinedir/
%dir %libwinedir/%winesodir/
%if_with buildwow64
%dir %libwinedir/%winepe32dir/
%dir %libwinedir/%winepe64dir/
%else
%dir %libwinedir/%winepedir/
%endif

%exclude %libdir/ntdll.so
%exclude %libdir/win32u.so

%libwinedir/%winesodir/avicap32.so
%libwinedir/%winesodir/ntdll.so
%libwinedir/%winesodir/ctapi32.so
%libwinedir/%winesodir/dnsapi.so
%libwinedir/%winesodir/dwrite.so
%libwinedir/%winesodir/bcrypt.so
%libwinedir/%winesodir/qcap.so
%libwinedir/%winesodir/odbc32.so
%libwinedir/%winesodir/crypt32.so
%libwinedir/%winesodir/kerberos.so
%libwinedir/%winesodir/mountmgr.so
%libwinedir/%winesodir/netapi32.so
%libwinedir/%winesodir/nsiproxy.so
%libwinedir/%winesodir/winspool.so
%libwinedir/%winesodir/msv1_0.so
%libwinedir/%winesodir/win32u.so
%libwinedir/%winesodir/winex11.so
%if_with wayland
%libwinedir/%winesodir/winewayland.so
%endif
%libwinedir/%winesodir/ws2_32.so
%if_with opencl
%libwinedir/%winesodir/opencl.so
%endif
%libwinedir/%winesodir/secur32.so
%libwinedir/%winesodir/gphoto2.so
%libwinedir/%winesodir/sane.so
%libwinedir/%winesodir/winepulse.so
%libwinedir/%winesodir/winealsa.so
%libwinedir/%winesodir/winevulkan.so
%libwinedir/%winesodir/opengl32.so
%if_with pcap
%libwinedir/%winesodir/wpcap.so
%endif
%libwinedir/%winesodir/winebus.so
%libwinedir/%winesodir/winebth.so
%libwinedir/%winesodir/winedmo.so
%libwinedir/%winesodir/wineusb.so
%libwinedir/%winesodir/wineps.so
%libwinedir/%winesodir/localspl.so
%libwinedir/%winesodir/winscard.so

%libwinedir/%winesodir/wine
%libwinedir/%winesodir/wine-preloader
%libwinedir/%winesodir/wine_make_autoreq_happy

# PE executables or PE stubs
%libwinedir/%winepedir/*.??*

%if_without mingw
%libwinedir/%winesodir/*.??*.so
%endif

%if_with buildwow64
%libwinedir/%winepe32dir/*.??*
%endif


%files common
%doc ANNOUNCE.md AUTHORS LICENSE README.md
%lang(de) %doc documentation/README-de.md
%lang(es) %doc documentation/README-es.md
%lang(fr) %doc documentation/README-fr.md
%lang(hu) %doc documentation/README-hu.md
%lang(it) %doc documentation/README-it.md
%lang(ko) %doc documentation/README-ko.md
%lang(nb) %doc documentation/README-no.md
%lang(pt) %doc documentation/README-pt.md
%lang(pt_BR) %doc documentation/README-pt_br.md
%lang(tr) %doc documentation/README-tr.md

#if "%winebindir" != "%libwinedir"
%dir %winebindir/
%if "%wineserver" != "wineserver"
%winebindir/wineserver
%endif

%_bindir/wine
%_bindir/wineserver

%_bindir/wineapploader

%_bindir/regsvr32
%_bindir/winecfg
%_bindir/regedit
%_bindir/msiexec

%_bindir/wineconsole

%_bindir/winedbg
%_bindir/wineboot
%_bindir/winepath

%_bindir/notepad
%_bindir/winefile

%_man1dir/notepad.*
%_man1dir/winefile.*

%_iconsdir/*

%_desktopdir/wine-mime-msi.desktop
%_desktopdir/wine-regedit.desktop
#_desktopdir/wine-serverkill.desktop
%_desktopdir/wine-uninstaller.desktop
%_desktopdir/wine-winecfg.desktop
%_desktopdir/wine-wineconsole.desktop
#_desktopdir/wine-winehelp.desktop

# danger
#_desktopdir/wine.desktop

%_datadir/desktop-directories/*.directory

%_man1dir/wine.*
%_man1dir/msiexec.*
%_man1dir/regedit.*
%_man1dir/regsvr32.*
%_man1dir/wineboot.*
%_man1dir/winecfg.*
%_man1dir/wineconsole.*
%_man1dir/winepath.*
%_man1dir/wineserver.*
%_man1dir/winedbg.*


%dir %_datadir/%wineproduct/
%_datadir/%wineproduct/wine.inf
%_datadir/%wineproduct/nls/
%_datadir/%wineproduct/fonts/
%_datadir/%wineproduct/winmd/

%files full

%files programs
%_bindir/winemine
%_man1dir/winemine.*
%_desktopdir/wine-notepad.desktop
%_desktopdir/wine-winefile.desktop
%_desktopdir/wine-winemine.desktop


%files devel-tools
%doc LICENSE
%_bindir/function_grep.pl
%_bindir/winebuild
%winebindir/winebuild
%_bindir/wmc
%_bindir/wrc
%_bindir/widl
%_bindir/wineg++
%winebindir/wineg++
%_bindir/winegcc
%winebindir/winegcc
%_bindir/winecpp
%winebindir/winecpp
%_bindir/winedump
%_bindir/winemaker
%_bindir/msidb

%_includedir/wine/
#_aclocaldir/wine.m4

%_man1dir/wmc.*
%_man1dir/wrc.*
%_man1dir/widl.*
%_man1dir/winebuild.*
%_man1dir/winedump.*
%_man1dir/wineg++.*
%_man1dir/winegcc.*
%_man1dir/winecpp.*
%_man1dir/winemaker.*


%files devel
%if_with buildwow64
%libwinedir/%winepe32dir/lib*.a
#libwinedir/%winepe64dir/lib*.a
%endif
%if_with mingw
%libwinedir/%winepedir/lib*.a
%endif
# fix for makefiles: Don't build native import libraries for PE-only build.
%if_without clang
%libwinedir/%winesodir/lib*.a
%endif

%changelog
