# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: widelands
Version: 1.2.1
Release: alt2
Epoch: 1

Summary: Open source realtime-strategy game
License: GPL-2.0-or-later
Group: Games/Strategy

Url: https://www.widelands.org
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires(pre): %name-data = %EVR

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libSDL2-devel
BuildRequires: libSDL2_image-devel
BuildRequires: libSDL2_mixer-devel
BuildRequires: libSDL2_ttf-devel
BuildRequires: boost-program_options-devel >= 1.48.0
BuildRequires: boost-signals-devel
BuildRequires: boost-asio-devel
BuildRequires: ctags
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: libglew-devel
BuildRequires: libpng-devel
BuildRequires: libcurl-devel
BuildRequires: libicu-devel
BuildRequires: asio-devel
BuildRequires: ctest
BuildRequires: python3
BuildRequires: doxygen

%description
Widelands is an open source (GPLed), realtime-strategy game, using SDL and
other free libraries, which is still under development. Widelands is inspired
by Settlers II (Bluebyte) and is partly similar to it, so if you know it,
you perhaps will have a thought what Widelands is all about.

%package data
Summary: Data files for widelands
Group: Games/Strategy
Requires(preun): %name = %EVR
BuildArch: noarch

%description data
Data files for widelands.

%prep
%setup
%patch -p1
%ifarch %e2k
# unsupported as of lcc 1.26.18 (mcst#7644)
sed -i '/-fno-elide-constructors/d' CMakeLists.txt
%endif

%build
%cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_INSTALL_PREFIX=%prefix \
    -DWL_INSTALL_BINDIR=%_bindir \
    -DWL_INSTALL_BASEDIR=%_datadir/%name \
    -DWL_INSTALL_DATADIR=%_datadir/%name \
    -DOPTION_BUILD_WEBSITE_TOOLS=OFF

%cmake_build

%install
%cmake_install

# Validate desktop file (provided by upstream)
desktop-file-validate %buildroot%_desktopdir/*.desktop

# Validate appdata (provided by upstream)
appstream-util validate-relax --nonet %buildroot%_datadir/metainfo/*.appdata.xml

%files
%doc ChangeLog CREDITS
%_man6dir/widelands.6.*
%_bindir/%name
%_iconsdir/hicolor/*/apps/*.png
%_datadir/metainfo/*.appdata.xml
%_desktopdir/*.desktop

%files data
%_datadir/%name

%changelog
