%def_disable snapshot
%define ver_major 1.45

%if "%__gcc_version_major" < "11"
%ifarch ppc64le
%def_disable check
%endif
%endif

Name: wayland-protocols
Version: %ver_major
Release: alt1

Summary: Wayland protocols
License: MIT
Group: System/X11
Url: https://wayland.freedesktop.org/

Vcs: https://gitlab.freedesktop.org/wayland/wayland-protocols.git

%if_disabled snapshot
Source: https://gitlab.freedesktop.org/wayland/wayland-protocols/-/releases/%version/downloads/%name-%version.tar.xz
#Source: https://wayland.freedesktop.org/releases/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildArch: noarch

%define wayland_ver 1.23

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ libwayland-client-devel >= %wayland_ver libwayland-server-devel

%description
wayland-protocols contains Wayland protocols that adds functionality not
available in the Wayland core protocol. Such protocols either adds
completely new functionality, or extends the functionality of some other
protocol either in Wayland core, or some other protocol in wayland-protocols.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_datadir/%name/
%_includedir/%name/
%_datadir/pkgconfig/%name.pc
%doc README.md GOVERNANCE* MEMBERS*

%changelog
