Name: vulkan
Version: 1.4.328.1
Release: alt1
Summary: Khronos group Vulkan API SDK

Group: System/Libraries
License: Apache-2.0
Url: http://www.khronos.org/

# https://github.com/KhronosGroup/Vulkan-Loader
Source0: vulkan-loader.tar
# https://github.com/KhronosGroup/Vulkan-Tools
Source1: vulkan-tools.tar
# https://github.com/KhronosGroup/Vulkan-ValidationLayers
Source2: vulkan-layers.tar

BuildRequires: bison chrpath
BuildRequires(pre): cmake gcc-c++
BuildRequires: libImageMagick-devel libpciaccess-devel libsystemd-devel
BuildRequires: python3-devel libxcb-devel libXau-devel libXdmcp-devel libX11-devel libXrandr-devel
BuildRequires: wayland-devel libwayland-server-devel libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel
# strict requires due internal dependency
BuildRequires: vulkan-headers = %version
BuildRequires: vulkan-registry = %version
BuildRequires: glslang-devel = 16.0.0
BuildRequires: libspirv-tools-devel >= 2025.4-alt0.1
BuildRequires: spirv-headers >= 1.5.5-alt20
# -layers need it
BuildRequires: vulkan-utility-libraries-devel = %version librobin-hood-hashing-devel
# -tools need it
BuildRequires: wayland-protocols

# textrel due asm optimisation in loader code
%ifarch i586
%set_verify_elf_method textrel=relaxed
%endif

%description
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader and API validation layer for
Vulkan.

%package -n lib%{name}1
Summary: Vulkan loader libraries
Group: System/Libraries
Requires: vulkan-filesystem = %EVR
Provides: %name = %EVR
Obsoletes: %name

%description -n lib%{name}1
Vulkan is a new generation graphics and compute API that provides
high-efficiency, cross-platform access to modern GPUs used in a wide
variety of devices from PCs and consoles to mobile phones and embedded
platforms.

This package contains the reference ICD loader for Vulkan.

%package validation-layers
Summary: Vulkan API validation layers
Group: Development/C++
Requires: lib%{name}1 = %version-%release

%description validation-layers
Vulkan API validation layer for developers.

%package -n lib%name-devel
Summary: Vulkan development package
Group: Development/C++
Requires: lib%{name}1 = %EVR, %{name}-headers = %version, %{name}-registry = %version
Provides: %name-devel = %EVR
Obsoletes: %name-devel

%description -n lib%name-devel
Development headers for Vulkan applications.

%package filesystem
Summary: Vulkan filesystem package
Group: System/Base
BuildArch: noarch

%description filesystem
Filesystem for Vulkan API.

%package tools
Summary: Vulkan tools and utilities
Group: System/X11
Requires: lib%{name}1 = %EVR
Obsoletes: %name-demos

%description tools
Tools and utilities that can assist development by enabling developers to
verify their applications correct use of the Vulkan API.

%prep
%setup -n %name-loader -b0 -b1 -b2
pushd ../vulkan-layers
# sigh inttypes
sed -i 's/inttypes.h/cinttypes/' layers/*.{cpp,h}
popd

%build
for dir in loader layers; do
pushd %_builddir/vulkan-"$dir"
%cmake \
	   -DCMAKE_BUILD_TYPE=RelWithDebInfo \
	   -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	   -DSPIRV_TOOLS_SEARCH_PATH=%_libdir \
	   -DSPIRV_TOOLS_OPT_SEARCH_PATH=%_libdir \
	   -DVULKAN_HEADERS_INSTALL_DIR=%_prefix \
	   -DGLSLANG_INSTALL_DIR=%_prefix \
	   -DSPIRV_HEADERS_INSTALL_DIR=%_prefix \
	   -DCMAKE_PREFIX_PATH=%buildroot%_datadir/cmake \
	   -DROBIN_HOOD_HASHING_INCLUDE_DIR=%_includedir
%cmake_build
%cmakeinstall_std
popd
done

# end finally -tools
pushd %_builddir/vulkan-tools
%cmake \
	   -DCMAKE_PREFIX_PATH=%buildroot%prefix \
	   -DGLSLANG_INSTALL_DIR=%_prefix
%cmake_build
%cmakeinstall_std
popd

%install
# do it again
for dir in layers loader tools; do
pushd %_builddir/vulkan-"$dir"
%cmakeinstall_std
popd
done
mkdir -p %buildroot%_sysconfdir/vulkan/explicit_layer.d
mkdir -p %buildroot%_datadir/vulkan/{explicit,implicit}_layer.d/ ||:
mkdir -p %buildroot%_datadir/vulkan/icd.d ||:

# remove RPATH
chrpath -d %buildroot%_bindir/{vulkaninfo,vkcubepp}

# remove static libs to make LTO checks happy
rm -rf %buildroot%_libdir/*.a ||:

%files tools
%_bindir/*

%files -n lib%{name}1
%doc README.md LICENSE.txt
%_libdir/libvulkan.so.1*

%files -n lib%name-devel
%_libdir/libvulkan.so
%_pkgconfigdir/vulkan.pc
%dir %_libdir/cmake/VulkanLoader
%_libdir/cmake/VulkanLoader/*.cmake

%files validation-layers
%_datadir/vulkan/explicit_layer.d/*.json
%_libdir/libVkLayer*.so

%files filesystem
%dir %_sysconfdir/vulkan
%dir %_sysconfdir/vulkan/explicit_layer.d
%dir %_datadir/vulkan
%dir %_datadir/vulkan/icd.d
%dir %_datadir/vulkan/explicit_layer.d
%dir %_datadir/vulkan/implicit_layer.d

%changelog
