%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _name vte
%define xdg_name org.gnome.Vte
%define ver_major 0.82
%define api_ver 2.91
# bindigs version for -gtk4 library
%define bind_ver 3.91

Name: %{_name}3
Version: %ver_major.1
Release: alt1.1

%def_disable static
%def_enable gtk3
%def_enable gtk4
%def_enable introspection
%def_enable docs
%def_disable glade
%ifarch %ix86 armh
%def_disable check
%else
%def_enable check
%endif
# removed in 0.69
%def_disable sixel

Summary: Terminal emulator widget for use with GTK+
License: LGPL-3.0-or-later
Group: Terminals
Url: https://www.gnome.org/

Vcs: https://gitlab.gnome.org/GNOME/vte.git

Requires: lib%name = %EVR

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define gtk3_ver 3.24.0
%define gtk4_ver 4.14
%define glib_ver 2.72.0
%define pango_ver 1.22
%define gir_ver 0.10.2
%define tls_ver 3.2.7
%define pcre_ver 10.21
%define lz4_ver 1.9
%define simdutf_ver 6.2.0
%define fmt_ver 11.0.0

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-systemd
BuildRequires: meson gcc-c++ gperf
BuildRequires: libncurses-devel libcairo-devel
BuildRequires: libgio-devel >= %glib_ver
%{?_enable_gtk3:BuildRequires: libgtk+3-devel >= %gtk3_ver}
%{?_enable_gtk4:BuildRequires: libgtk4-devel >= %gtk4_ver}
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgnutls-devel >= %tls_ver
BuildRequires: libfribidi-devel
BuildRequires: libpcre2-devel >= %pcre_ver
BuildRequires: vala-tools libvala-devel
BuildRequires: pkgconfig(liblz4) >= %lz4_ver
BuildRequires: libfast_float-devel
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(fmt) >= %fmt_ver
BuildRequires: pkgconfig(simdutf) >= %simdutf_ver
%{?_enable_glade:BuildRequires: libgladeui2.0-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gir_ver %{?_enable_gtk3:libgtk+3-gir-devel}
%{?_enable_gtk4:BuildRequires:libgtk4-gir-devel}}
%{?_enable_docs:BuildRequires: gi-docgen}

%description
VTE is a terminal emulator widget for use with GTK+3

%package gtk4
Summary: VTE Terminal for GTK4
Group: Terminals
Requires: lib%name = %EVR

%description gtk4
GTK4-based VTE terminal emulator

%package utils
Summary: VTE utilities and test programs
Group: Terminals
Requires: lib%name = %EVR

%description utils
Utilities, samples and test programs distributed with VTE, a terminal
emulator widget for use with GTK+3.

%package -n lib%name
Summary: Terminal emulator widget library for use with GTK+3
Group: System/Libraries

%description -n lib%name
VTE is a terminal emulator widget for use with GTK+3.
This package contains the VTE shared libraries.

%package -n lib%name-devel
Summary: Development files for VTE
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
VTE is a terminal emulator widget for use with GTK+3. This package
contains the files needed for building applications using VTE.

%package -n lib%name-devel-doc
Summary: Development documentation for VTE
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
API documentation for the VTE library.
VTE is a terminal emulator widget for use with GTK+3.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for VTE
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
VTE is a terminal emulator widget for use with GTK+3. This package
contains the libraries needed for building applications statically
linked with VTE.
%endif  # enabled static

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library


%define pkgdocdir %_docdir/%name-%version

%prep
%setup -n %_name-%version
%ifarch %e2k
# fixes "multiple definition of" error at linking
sed -i "1i #define set_child_setup set_child_setup2" src/spawn.cc
# unsupported as of lcc 1.29.12 (mcst#9592)
sed -i '/-fdirectives-only/d' src/meson.build
%endif

%build
%meson \
    %{subst_enable_meson_bool gtk3 gtk3} \
    %{subst_enable_meson_bool gtk4 gtk4} \
    %{subst_enable_meson_bool introspection gir} \
    %{subst_enable_meson_bool docs docs} \
    %{subst_enable_meson_bool glade glade}
%nil
%meson_build

%install
%meson_install
# fix permissions
chmod 755 %buildroot%_sysconfdir/profile.d/vte.sh

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS README.md %buildroot%pkgdocdir/
install -p -m644 doc/*.txt %buildroot%pkgdocdir/

%find_lang %_name-%api_ver --output=%name.lang

%check
%__meson_test

%files
%_bindir/%_name-%api_ver
%_desktopdir/%xdg_name.App.Gtk3.desktop
%_datadir/xdg-terminals/%xdg_name.App.Gtk3.desktop

%files gtk4
%_bindir/%_name-%api_ver-gtk4
%_desktopdir/%xdg_name.App.Gtk4.desktop
%_datadir/xdg-terminals/%xdg_name.App.Gtk4.desktop

%files -n lib%name -f %name.lang
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/README.md
%{?_enable_gtk3:%_libdir/lib%_name-%api_ver.so.*}
%{?_enable_gtk4:%_libdir/lib%_name-%api_ver-gtk4.so.*}
%_sysconfdir/profile.d/vte.*sh
%_libexecdir/vte-urlencode-cwd
%_userunitdir/vte-spawn-.scope.d/defaults.conf

%files -n lib%name-devel
%pkgdocdir/*.txt
%_includedir/*
%{?_enable_gtk3:%_libdir/lib%_name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.*}
%{?_enable_gtk4:%_libdir/lib%_name-%api_ver-gtk4.so
%_pkgconfigdir/%_name-%api_ver-gtk4.pc
%_vapidir/%_name-%api_ver-gtk4.*}
%if_enabled glade
%_datadir/glade/catalogs/vte-%api_ver.xml
%_datadir/glade/pixmaps/hicolor/*x*/actions/widget-vte-terminal.png
%endif

%if_enabled docs
%files -n lib%name-devel-doc
%{?_enable_gtk3:%_datadir/doc/%_name-%api_ver}
%{?_enable_gtk4:%_datadir/doc/%_name-%api_ver-gtk4}
%endif

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif	# enabled static

%if_enabled introspection
%files -n lib%name-gir
%{?_enable_gtk3:%_typelibdir/Vte-%api_ver.typelib}
%{?_enable_gtk4:%_typelibdir/Vte-%bind_ver.typelib}

%files -n lib%name-gir-devel
%{?_enable_gtk3:%_girdir/Vte-%api_ver.gir}
%{?_enable_gtk4:%_girdir/Vte-%bind_ver.gir}
%endif

%changelog
