%define ver_major 0.28

Name: vte
Version: %ver_major.2
Release: alt5

%def_enable pty_helper
%def_disable static
%def_disable python
%define gtk_api_ver 2.0
%define vte_api_ver 0.0

Summary: Terminal emulator widget for use with GTK+
License: LGPLv2
Group: Terminals
Url: http://www.gnome.org

Obsoletes: vte-utils

Requires: lib%name = %version-%release

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch: vte-0.28.2-alt-python.patch

# https://bugzilla.gnome.org/show_bug.cgi?id=663779
# http://bugzilla-attachments.gnome.org/attachment.cgi?id=201649
Patch1: vte-virtual_modifier_mapping.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=729533
#https://bug729533.bugzilla-attachments.gnome.org/attachment.cgi?id=279320
Patch2: vte-0.28.2-paste-fix.diff

%define gtk_ver 2.21.6
%define gtk3_ver 2.90.0
%define glib_ver 2.22.0
%define pango_ver 1.22

BuildPreReq: rpm-build-python

BuildRequires: libSM-devel libncurses-devel libcairo-devel
BuildRequires: intltool >= 0.35.0
BuildRequires: gtk-doc >= 1.1.0
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+2-devel >= %gtk_ver
BuildRequires: libpango-devel >= %pango_ver
%{?_enable_python:BuildRequires: python-module-pygobject-devel python-module-pygtk-devel}
BuildRequires: gobject-introspection-devel

%description
VTE is a terminal emulator widget for use with GTK+

%package -n gnome-pty-helper
Summary: Helper setuid application
Group: Graphical desktop/GNOME

%description -n gnome-pty-helper
gnome-pty-helper is a program that setuid application used to open a
pseudo-terminal, set the permissions, ownership and record user login
information. This program is called internally by VTE library.

%package -n lib%name
Summary: Terminal emulator widget library for use with GTK+
Group: System/Libraries
Requires: gnome-pty-helper

%description -n lib%name
VTE is a terminal emulator widget for use with GTK+.
This package contains the VTE shared libraries.

%package -n lib%name-devel
Summary: Development files for VTE
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
VTE is a terminal emulator widget for use with GTK+. This package
contains the files needed for building applications using VTE.

%package -n lib%name-devel-doc
Summary: Development documentation for VTE
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: lib%name-devel < %version

%description -n lib%name-devel-doc
API documentation for the VTE library.
VTE is a terminal emulator widget for use with GTK+.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for VTE
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
VTE is a terminal emulator widget for use with GTK+. This package
contains the libraries needed for building applications statically
linked with VTE.
%endif	# enabled static

%package -n python-module-%name
Summary: Python bindings for VTE
Group: Development/Python
Requires: lib%name = %version-%release
# not added automatically
Requires: python-module-pygtk

%description -n python-module-%name
VTE is a terminal emulator widget for use with GTK+. This package
contains bindings to VTE for the Python scripting language.

%package -n python-module-%name-devel
Summary: Development files for Python bindings for VTE
Group: Development/Python
Requires: python-module-%name = %version-%release
Requires: lib%name-devel = %version-%release

%description -n python-module-%name-devel
VTE is a terminal emulator widget for use with GTK+. This package
contains development files for bindings to VTE for the Python scripting
language.

%define helperdir %_libdir/%name
%define pkgdocdir %_docdir/%name-%version

%prep
%setup
%patch
%patch1 -p1
%patch2 -p1

%build
%add_optflags %(getconf LFS_CFLAGS) -Wno-incompatible-pointer-types
%autoreconf
%{?_enable_python:export PYTHON=%__python}
%configure \
	--disable-dependency-tracking \
	--libexecdir=%helperdir \
	--without-glX \
%if_enabled pty_helper
	--enable-gnome-pty-helper \
%else
	--disable-gnome-pty-helper \
%endif
	--enable-shared \
	%{subst_enable static} \
	%{subst_enable python} \
	--with-gtk=%gtk_api_ver
%nil
%make_build

%install
%makeinstall_std

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS ChangeLog MAINTAINERS NEWS README %buildroot%pkgdocdir/
bzip2 %buildroot%pkgdocdir/ChangeLog
ln -s %_licensedir/LGPL-2 %buildroot%pkgdocdir/COPYING

install -p -m644 doc/utmpwtmp.txt doc/boxes.txt \
    %buildroot%pkgdocdir/
install -p -m644 src/iso2022.txt \
    %buildroot%pkgdocdir/
install -p -m644 doc/openi18n/*.txt \
    %buildroot%pkgdocdir/

# Remove unpackaged files
find %buildroot -type f -name '*.la' -delete

%find_lang %name-%vte_api_ver --output=%name.lang

%check
%make -k check VERBOSE=1

%files
%_bindir/*

%if_enabled pty_helper
%files -n gnome-pty-helper
%dir %helperdir
%attr(2711,root,utmp) %helperdir/gnome-pty-helper
%endif

%files -n lib%name -f %name.lang
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/COPYING
%pkgdocdir/ChangeLog.bz2
%pkgdocdir/MAINTAINERS
%pkgdocdir/NEWS
%pkgdocdir/README
%_libdir/*.so.*
%_datadir/%name

%files -n lib%name-devel
%pkgdocdir/*.txt
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/vte.pc

%files -n lib%name-devel-doc
%doc %_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif	# enabled static

%if_enabled python
%files -n python-module-%name
%python_sitelibdir/gtk-%gtk_api_ver/*.so

%files -n python-module-%name-devel
%_datadir/pygtk/%gtk_api_ver/defs/vte.defs
%_libdir/pkgconfig/pyvte.pc
%endif

%changelog
