Name:           vncshare
Version:        0.10
Release:        alt1
Summary:        VNC shared screens infrastructure
Group:          Networking/Remote access
Source:         %name-%version.tar
BuildArch:      noarch
License:        MIT

Requires:       /usr/bin/vncserver
BuildRequires:  /usr/bin/magick rpm-build-python3

%description
A set of tools for sharing speaker's PC screen / window among listeners PCs via VNC

%package        installers
Summary:        VNC shared screens infrastructure install tools
Group:          Graphical desktop/XFce
%description installers
Desktop and panel icons installer and GIO enabler for vncshare

%prep
%setup

%define sizes 16 32 48 64 96 128
%build
for F in VNC*.svg; do for S in %sizes; do
  mkdir -p ${S}x${S}/apps
  magick $F ${S}x${S}/apps/${F##.svg}.png
done; done

%install
for F in VNC*[A-Z]; do install -D $F %buildroot%_bindir/$F; done
for F in VNC*.desktop; do install -D $F %buildroot%_desktopdir/$F; done
for F in VNC*.svg; do install -D $F %buildroot%_iconsdir/hicolor/scalable/apps/$F; done
for F in */*/*.png; do
  install -D $F %buildroot%_iconsdir/hicolor/$F
done
for prog in *.py *.sh; do
 install -D $prog %buildroot%_libexecdir/%name-$prog
done

%files
%doc *.md
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%files installers
%_libexecdir/*

%changelog
