Name:     vml
Version:  0.1.11
Release:  alt1

Summary:  Tool for easily and transparently work with qemu virtual machines
License:  MIT
Group:    Emulators
Url:      https://github.com/Obirvalger/vml

Packager: Mikhail Gordeev <obirvalger@altlinux.org>

Source:   %name-%version.tar

BuildRequires: libssl-devel
BuildRequires(pre): rpm-build-rust
BuildRequires: /proc

Requires: rsync socat openssh-clients /usr/bin/kvm cloud-utils-cloud-localds

ExclusiveArch: aarch64 x86_64

%description
VML is a tool for easily and transparently work with qemu virtual machines.
Virtual machines present as directories with vml.toml files in it. VML is able
to initialize images with cloud-init. Virtual machines with ALT, Centos,
Debian, Fedora, openSUSE and Ubuntu could be created with just one command.

%prep
%setup

%build
export RUSTFLAGS="${RUSTFLAGS} -g"
%ifarch ppc64le
cargo build --no-default-features --features=native-tls --release %{?_smp_mflags} --offline
%else
cargo build --release %{?_smp_mflags} --offline
%endif

%install
%rust_install
install -Dm 644 files/configs/config.toml %buildroot%_sysconfdir/%name/config.toml
install -Dm 644 files/configs/images.toml %buildroot%_sysconfdir/%name/images.toml

mkdir -p %buildroot%_datadir/zsh/site-functions
%buildroot%_bindir/%name completion zsh > %buildroot%_datadir/zsh/site-functions/_%name
mkdir -p %buildroot%_datadir/bash-completion/completions
%buildroot%_bindir/%name completion bash > %buildroot%_datadir/bash-completion/completions/%name
mkdir -p %buildroot%_datadir/fish/vendor_completions.d
%buildroot%_bindir/%name completion fish > %buildroot%_datadir/fish/vendor_completions.d/%name.fish

%files
%_bindir/%name
%_sysconfdir/%name
%config(noreplace) %attr(0644,root,root) %_sysconfdir/%name/config.toml
%config(noreplace) %attr(0644,root,root) %_sysconfdir/%name/images.toml
%_datadir/zsh/site-functions/_%name
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/%name.fish
%doc doc *.md

%changelog
