%def_disable demos
%def_disable tests
%define major 1

Name: vkd3d
Version: 1.16
Release: alt1
Summary: The vkd3d 3D Graphics Library

Group: System/Libraries
License: LGPL-2.1
Url: https://source.winehq.org/git/vkd3d.git/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

# Automatically added by buildreq on Sat Mar 25 2023 (-ba)
BuildRequires: flex libvulkan-devel libspirv-tools-devel spirv-headers wine-devel-tools
BuildRequires: perl-JSON DirectXShaderCompiler

%if_enabled demos
BuildRequires: libxcb-devel libxcbutil-devel libxcbutil-keysyms-devel libxcbutil-icccm-devel
%endif
%if_enabled tests
BuildRequires: vulkan-lvp
%endif

# same as wine
ExclusiveArch: %ix86 x86_64 aarch64

%description
Vkd3d is a 3D graphics library built on top of Vulkan. It has an API very
similar, but not identical, to Direct3D 12.

%package -n lib%{name}%{major}
Summary: %{name} libraries
Group: System/Libraries

%description -n lib%{name}%{major}
Vkd3d is a 3D graphics library built on top of Vulkan. It has an API very
similar, but not identical, to Direct3D 12.

%package devel
Summary: %name development package
Group: Development/C
Requires: lib%{name}%{major} = %EVR
Requires: %name-utils = %EVR

%description devel
Development headers for %name.

%package utils
Summary: %name utils
Group: Development/C
Requires: lib%{name}%{major} = %EVR

%description utils
%name utils.

%package demos
Summary: %name demos
Group: Development/C
Requires: lib%{name}%{major} = %EVR

%description demos
%name demos.

%prep
%setup
%patch -p1
%autoreconf
%configure \
  %{subst_enable demos} \
  %{subst_enable tests} \
  --with-spirv-tools
  %nil

%build
%make_build

# still fails
%if_enabled tests
%check
%make check
%endif

%install
%makeinstall
%if_enabled demos
mkdir -p %buildroot%_bindir
for f in demos/{gears,triangle}; do
  cp -a "$i" %buildroot%_bindir/%{name}_"$f";
done
%endif
# to make LTO checks happy
rm -f %buildroot%_libdir/*.a

%files -n lib%{name}%{major}
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files utils
%_bindir/vkd3d-compiler
%_bindir/vkd3d-dxbc

%if_enabled demos
%files demos
%_bindir/*
%exclude %_bindir/vkd3d-compiler
%endif

%changelog
