
# 'reshade' commit
%global commit ee98003229465f9872e983a43a83b8cddc054fce
%global shortcommit %(c=%commit; echo ${c:0:7})

Name: vkBasalt
Version: 0.3.2.10
Release: alt1.2
Summary: Vulkan post processing layer
Packager: Ilya Mashkin <oddity@altlinux.ru>
# The entire source code is zlib except:
# * ASL 2.0: include/vulkan/
License: zlib and ASL 2.0
Group: System/Configuration/Hardware
Url: https://github.com/DadSchoorse/vkBasalt
Source0: %url/archive/v%version/%name-%version.tar.gz

BuildRequires: gcc-c++ >= 9
BuildRequires: glibc-devel
BuildRequires: glslang
BuildRequires: meson
BuildRequires: spirv-headers
BuildRequires: libspirv-tools-devel
BuildRequires: libvulkan-devel
BuildRequires: vulkan-tools
BuildRequires: vulkan-validation-layers

BuildRequires: pkgconfig(vulkan)
BuildRequires: pkgconfig(x11)

Provides: bundled(reshade) = 0~git%shortcommit

ExcludeArch: ppc64le armh

%description
vkBasalt is a Vulkan post processing layer to enhance the visual graphics of
games.

Currently, the build in effects are:

  - Contrast Adaptive Sharpening
  - Denoised Luma Sharpening
  - Fast Approximate Anti-Aliasing
  - Enhanced Subpixel Morphological Anti-Aliasing
  - 3D color LookUp Table

It is also possible to use Reshade Fx shaders.

%prep
%setup
%ifarch %e2k
sed -i 's/module _module;/using edg_module=module; edg_&/' src/reshade/effect_codegen.hpp
%endif

%build
%meson \
    -Dappend_libdir_vkbasalt=true
%meson_build

%install
%meson_install

# Configuration file
install -Dpm 0644 config/%name.conf -t %buildroot%_sysconfdir/

%files
%doc README.md
%_datadir/vulkan/implicit_layer.d/%name.json
%_libdir/vkbasalt/
%config(noreplace) %_sysconfdir/%name.conf

%changelog
