%define _unpackaged_files_terminate_build 1

Name:		viking
Version:	1.10
Release:	alt3

Summary:	GPS data editor, analyzer and viewer

Group:		Sciences/Geosciences
License:	GPL-2.0-or-later
URL:		https://sourceforge.net/projects/viking/
VCS:        https://github.com/viking-gps/viking

Source:	%{name}-%{version}.tar

BuildRequires: intltool
BuildRequires: gtk-doc
BuildRequires: xxd
BuildRequires: libexpat-devel
BuildRequires: libcurl-devel
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(gdk-pixbuf-2.0)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(libgeoclue-2.0)
BuildRequires: pkgconfig(gexiv2)
BuildRequires: yelp-tools
BuildRequires: libgps-devel
BuildRequires: pkgconfig(bzip2)
BuildRequires: pkgconfig(libmagic)
BuildRequires: pkgconfig(sqlite3)
BuildRequires: pkgconfig(libzip)
BuildRequires: pkgconfig(liblzma)
BuildRequires: pkgconfig(nettle)
BuildRequires: libnova-devel

Requires: gpsbabel
Requires: /usr/bin/unbuffer
Requires: geoclue2

%description
Viking aims to be easy to use, yet powerful in accomplishing a wide
variety of GPS related tasks. It uses a hierarchical layering system
to organize GPS data, maps, and other layer types with spatial data,
such as coordinate lines.

Some of the things you can use Viking for are:

* Uploading and downloading waypoints, tracks to/from GPS.
* Realtime GPS tracking and track recording.
* Import and export of gpx files.
* Preparing tracks and waypoints for trips using maps from services
such as OpenStreetmap and Terraserver. You only need to upload the data
to your GPS before you leave. The maps together with your tracks
and waypoints can also be printed and used during the trip.
* After trips, tracks and waypoints from GPS can be downloaded,
stored, managed and reused in later trips.
* Analyzing OHV and hiking trips, understanding where you went and
how far you were from something.
* Making waypoints and tracks to follow to easily get someplace
you've never been before or don't have GPS data for but Terraserver
maps exist for it.
* Making maps with coordinate lines.
* Analyzing speed at different places, adding waypoints where you forgot
to mark one but did slow down or stop.

%prep
%setup -q
sed -i 's|^Categories=.*|Categories=Science;Maps;Geography;|' src/viking.desktop.in

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
           --disable-mapnik \
           --disable-zip
%make

%install
%makeinstall

%find_lang %name

%check
make check

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING NEWS README TODO doc/
%_bindir/%name
%_datadir/applications/%{name}.desktop
%_datadir/icons/hicolor/48x48/apps/%{name}.png
%exclude %_datadir/icons/hicolor/icon-theme.cache
%_man1dir/%{name}.1*
%_datadir/%name
%dir %_datadir/help/C/%name/
%_datadir/help/C/%name/*

%changelog
