%define _unpackaged_files_terminate_build 1

Name: veyon
Version: 4.9.7
Release: alt1

Summary: Open source computer monitoring and classroom management
Summary(ru.UTF-8): Программа с открытым кодом для контроля компьютеров и организации учебного процесса
License: GPLv2
Group: Education
Url: https://veyon.io/
VCS: https://github.com/veyon/veyon/

Source0: %name-%version.tar
Source1: %name-%version-3rdparty-kldap.tar
Source2: %name-%version-3rdparty-kldap-qt-compat.tar
Source3: %name-%version-3rdparty-libfakekey.tar
Source4: %name-%version-3rdparty-libvncserver.tar
Source5: %name-%version-3rdparty-libvncserver-webclients-novnc.tar
Source6: %name-%version-3rdparty-qthttpserver.tar
Source7: %name-%version-3rdparty-qthttpserver-src-3rdparty-http-parser.tar
Source8: %name-%version-3rdparty-x11vnc.tar
Source9: %name-%version-3rdparty-libvncserver-doc-doxygen-awesome-css.tar
Source100: veyon-config-dm-login.sh
Patch0: %name-%version-alt.patch
Patch1: alt-veyon-libdir.patch
Patch2: alt-fix-dm-login.patch

Requires: polkit qca-qt6-ossl qt6-translations
Obsoletes: italc3

BuildRequires(pre): rpm-macros-cmake
BuildRequires: rpm-build-kf6
BuildRequires: gcc-c++ make cmake
BuildRequires: qt6-base-devel
BuildRequires: qt6-tools-devel
BuildRequires: qt6-5compat-devel
BuildRequires: libjpeg-devel
BuildRequires: zlib-devel
BuildRequires: liblzo2-devel
BuildRequires: libssl-devel
BuildRequires: libldap-devel
BuildRequires: libpam0-devel
BuildRequires: libsasl2-devel
BuildRequires: libpng-devel
BuildRequires: libXrandr-devel
BuildRequires: libXinerama-devel
BuildRequires: libqca-qt6-devel
BuildRequires: libXdamage-devel
BuildRequires: libXtst-devel
BuildRequires: libfakekey-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXcursor-devel
BuildRequires: libproc2-devel

%description
Veyon is a free and open source software
for computer monitoring and classroom management supporting Windows and Linux.
It enables teachers to view and control computer labs and interact with students.
Veyon is available in different languages and provides lots of useful features:

* see what's going on in computer labs in overview mode and take screenshots
* remote control computers to support and help users
* broadcast teacher's screen to students in realtime by using demo mode
(either in fullscreen or in a window)
* lock workstations for attracting attention to teacher
* send text messages to students
* powering on/off and rebooting computers remote
* remote logoff and remote execution of arbitrary commands/scripts
* home schooling - Veyon's network technology is not restricted to a subnet
and therefore students at home can join lessons via VPN connections
just by installing the Veyon service.

%description -l ru_RU.UTF-8
Veyon - это бесплатное программное обеспечение с открытым исходным кодом
для контроля компьютеров и организации учебного процесса, поддерживающее Windows и Linux.
Оно позволяет учителям просматривать и контролировать компьютерные классы
и взаимодействовать со студентами.
Veyon доступен на разных языках и предоставляет множество полезных функций:

* просмотр происходящего в компьютерных классах в режиме обзора и создание скриншотов
* удаленное управление компьютерами для поддержки и помощи пользователям
* трансляция экрана учителя ученикам в режиме реального времени,
используя демонстрационный режим (либо в полноэкранном режиме, либо в окне)
* блокировка рабочих мест для привлечения внимания к учителю
* отправка текстовых сообщений студентам
* удалённое включение / выключение и перезагрузка компьютеров
* удаленный выход из системы и удаленное выполнение произвольных команд / скриптов
* домашнее обучение - сетевые технологии Veyon не ограничиваются подсетью,
поэтому студенты могут присоединиться к урокам через VPN-подключения,
просто установив Veyon у себя на домашнем ПК.

%prep
%setup -a1 -a2 -a3 -a4 -a5 -a6 -a7 -a8 -a9
%autopatch -p1

# Fix: error: "_FORTIFY_SOURCE" redefined [-Werror]
# _FORTIFY_SOURCE enabled by default
sed -i -e '/-D_FORTIFY_SOURCE=2/d' CMakeLists.txt

%ifarch %e2k
sed -i "s/-Werror/-Wno-error/" cmake/modules/SetDefaultTargetProperties.cmake
# workaround of SIGILL in ecf_opt64 from LCC 1.25.23
sed -i "s/QOverload<int>::of(&QComboBox::/(void(QComboBox::*)(int))(\&QComboBox::/" \
	core/src/Configuration/UiMapping.h
%endif

%build
%cmake \
%ifarch %e2k
	-DWITH_LTO=OFF \
%endif
	-DSYSTEMD_SERVICE_INSTALL_DIR:PATH=%_unitdir \
	%nil
%cmake_build

%install
%cmakeinstall_std
%__install -D -m 0755 %SOURCE100 %buildroot%_datadir/veyon/

%files
%doc COPYING README.md
%_libdir/*.so
%_libdir/veyon/
%_bindir/veyon-*
%_unitdir/veyon.service
%_datadir/veyon/
%_datadir/pixmaps/veyon-*.xpm
%_datadir/polkit-1/actions/io.veyon.veyon-*.policy
%_iconsdir/hicolor/*/apps/veyon-*
%_desktopdir/veyon-*.desktop

%changelog
