%define _unpackaged_files_terminate_build 1

Name: vdo
Version: 8.2.2.2
Release: alt2

Summary: Management tools for Virtual Data Optimizer
License: GPLv2
Group: System/Base

Url: http://github.com/dm-vdo/vdo
Source: %name-%version.tar
#Patch0: %%name-%%version.patch
Patch1: vdo-8.2.0.2-e2k.patch
Patch2: 0001-Support-LoongArch-architecture.patch

ExclusiveArch: x86_64 aarch64 ppc64le ppc64 s390 s390x %e2k loongarch64

BuildRequires: libdevmapper-devel libdevmapper-event-devel
BuildRequires: libuuid-devel libblkid-devel
BuildRequires: zlib-devel

%description
Virtual Data Optimizer (VDO) is a device mapper target that delivers
block-level deduplication, compression, and thin provisioning.

This package provides the user-space management tools for VDO.

%package support
Summary: Support tools for Virtual Data Optimizer
Group: System/Base
Requires: libuuid >= 2.23

%description support
Virtual Data Optimizer (VDO) is a device mapper target that delivers
block-level deduplication, compression, and thin provisioning.

This package provides the user-space support tools for VDO.

%prep
%setup
#%%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%make

%install
%make install DESTDIR=%buildroot INSTALLOWNER= name=%name \
  bindir=%_bindir defaultdocdir=%_defaultdocdir \
  mandir=%_mandir sysconfdir=%_sysconfdir

# Fix installed
mkdir -p %buildroot%_datadir/bash-completion/completions
mv %buildroot%_sysconfdir/bash_completion.d/* %buildroot%_datadir/bash-completion/completions/

%files
%_bindir/vdodmeventd
%_bindir/vdodumpconfig
%_bindir/vdoforcerebuild
%_bindir/vdoformat
%_bindir/vdosetuuid
%_bindir/vdostats
%dir %_defaultdocdir/%name
%doc %_defaultdocdir/%name/COPYING
%_defaultdocdir/%name/examples
%_man8dir/vdodmeventd.8*
%_man8dir/vdodumpconfig.8*
%_man8dir/vdoforcerebuild.8*
%_man8dir/vdoformat.8*
%_man8dir/vdosetuuid.8*
%_man8dir/vdostats.8*
%_datadir/bash-completion/completions/vdo*

%files support
%_bindir/adaptLVMVDO.sh
%_bindir/vdoaudit
%_bindir/vdodebugmetadata
%_bindir/vdodumpblockmap
%_bindir/vdodumpmetadata
%_bindir/vdolistmetadata
%_bindir/vdoreadonly
%_bindir/vdorecover
%_bindir/vdoregenerategeometry
%_man8dir/adaptlvm.8*
%_man8dir/vdoaudit.8*
%_man8dir/vdodebugmetadata.8*
%_man8dir/vdodumpblockmap.8*
%_man8dir/vdodumpmetadata.8*
%_man8dir/vdolistmetadata.8*
%_man8dir/vdoreadonly.8*
%_man8dir/vdorecover.8*
%_man8dir/vdoregenerategeometry.8*

%changelog
