# Vala is written in Vala itself. To solve bootstrap problem we pre-compile it to C
# and use those C sources during bootstrap phase. Next package rebuilds must be done
# without bootstrap define.
%def_disable snapshot
%def_enable check
%{?_enable_snapshot:%def_with bootstrap}
%define ver_major 0.56
%define api_ver 0.56

Name: vala
Version: %ver_major.18
Release: alt1

Summary: Vala is a programming language which makes GNOME programming easy
Group: Development/C
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/Vala

Vcs: https://gitlab.gnome.org/GNOME/vala.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
%if_with bootstrap
Patch: %name-%version-%release-pregenerated.patch
%endif
Patch1: %name-0.39.7-alt-fixes.patch

Requires(pre): rpm-build-vala vapi-common = %EVR

# to avoid duplicate provides
%filter_from_provides /libsoup-2.4\|libsoup-3.0\|libgeoclue-2.0/d

BuildRequires(pre): rpm-build-vala
BuildRequires: /proc flex libgio-devel >= 2.48.0 xsltproc help2man dbus-tools-gui gobject-introspection-devel
# since 0.37
BuildRequires: libgraphviz-devel
%if_without bootstrap
# VALAC_BOOTSTRAP_REQUIRED
BuildRequires: vala >= 0.39.5.8
%endif

%description
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

Vala is designed to allow access to existing C libraries, especially GObject-based
libraries, without the need for runtime bindings. Each to be used library requires a Vala
API file at compile-time, containing the class and method declarations in Vala
syntax. Vala currently comes with experimental bindings for GLib and GTK+. It's planned to
provide generated bindings for the full GNOME Platform at a later stage.

%package -n vapi-common
Summary: Common empty package with dir for vapi files
Group: Development/Other
BuildArch: noarch
Provides: %_datadir/vala/vapi

%description -n vapi-common
Common empty package with dir for vapi files.

%package -n lib%name-devel
Summary: Development files for embedding Vala translator
Group: Development/C
Requires: %name = %EVR

%description -n lib%name-devel
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This package contains infrastructure files to embed Vala translator into your programs

%package doc
Summary: Documentation for Vala programming language
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description doc
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This package contains Vala documentation for GNOME DevHelp.

%package tools
Summary: Tools for creating Vala API specifications and new projects
Group: Development/C
Requires: %name = %EVR

%description tools
Vala is a programming language that aims to bring modern programming language
features to GNOME developers without imposing any additional runtime requirements and
without using a different ABI compared to applications and libraries written in C.

This packages contains additional tools to generate Vala projects and API specifications
for existing C and C++ libraries.

%package -n valadoc
Summary: Vala documentation generator
Group: Development/Other
Conflicts: %name < %version

%description -n valadoc
Valadoc is a documentation generator for Vala projects. It extracts
source code from Vala source files and can output various formats of
documentation like GTK-Doc or GIR documentation.

%package -n valadoc-devel
Summary: Vala documentation generator (devel package)
Group: Development/Other
Requires: valadoc = %EVR

%description -n valadoc-devel
Development files for Valadoc.

%prep
%setup
%patch1 -p1 -b .alt_fixes

# since dbus-1.14.4
# dbus-run-session: EOF reading address from bus daemon, so
sed -i '/dbus\//d' tests/Makefile*

# Automake now requires to have ChangeLog and m4, fake them
[ ! -f ChangeLog ] && touch ChangeLog
[ ! -d m4 ] && mkdir m4

# version in .tarball-version file
%{?_with_bootstrap:echo "%version" > .tarball-version}

# whether external bootstrapping is in use or not we always want to build
# a compiler with the compiler itself. So first compile an intermediate
# (bootstrapping) compiler in a separate directory

%if_with bootstrap
# create a copy of sources. it's not that neat but otherwise
# our bootstrapping patch would "taint" sources used for
# the final build

mkdir bootstrap-build
# copy everythig but bootstrap-build recursively to bootstrap-build
find ./ -mindepth 1 -maxdepth 1 \( -name 'bootstrap-*' -prune -o \
	-exec cp -pr {} bootstrap-build \; \)
cd bootstrap-build
# apply pregenerated patch
%patch0 -p1
cd ..
%else
# use the directory for the "off-source" build
mkdir bootstrap-build
%endif

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf

# build an intermediate version of the compiler
BSINSTALL=$(pwd)/bootstrap-install
mkdir "$BSINSTALL"

cd bootstrap-build

%if_with bootstrap
autoreconf -v --install
./configure --prefix="$BSINSTALL"

# Make stamps for pregenerated source code so that Vala build system would not run valac again
for i in vala codegen ccode gee ; do
    touch $i/$i.vala.stamp
done
touch vapigen/{vapigen,vapicheck}.vala.stamp
touch compiler/valac.vala.stamp
%else
../configure --prefix="$BSINSTALL"
%endif

%make
make install
cd ..

# now build a pristine variant of the compiler to be packaged
OLD_PATH="$PATH"
export PATH="$BSINSTALL/bin:$PATH"
%configure
# Delete stamps to force re-generation of C code with bootstrapped valac
find . -name '*.stamp' | xargs -r rm
%make
rm -rf bootstrap-build "$BSINSTALL"
export PATH="$OLD_PATH"

%install
%makeinstall_std
# own this directory for third-party *.vapi files
mkdir -p %buildroot%_datadir/vala/vapi

%check
%make -k check VERBOSE=1

%files
%_bindir/valac
%_bindir/valac-%api_ver
%_bindir/vala
%_bindir/vala-%api_ver
%_libdir/lib%name-%api_ver.so.*
%dir %_libdir/%name-%api_ver
%_libdir/%name-%api_ver/libvalaccodegen.so
%_man1dir/valac*
%dir %_datadir/vala-%api_ver
%dir %_datadir/vala-%api_ver/vapi
%_datadir/vala-%api_ver/vapi/*
%_datadir/%name/vapi/lib%name-%api_ver.vapi
%doc AUTHORS COPYING NEWS README THANKS

%exclude %_libdir/%name-%api_ver/*.la

%files -n vapi-common
%dir %_datadir/vala
%dir %_datadir/vala/vapi

%files -n lib%name-devel
%_includedir/vala-%api_ver
%_pkgconfigdir/*.pc
%exclude %_pkgconfigdir/valadoc*.pc
%_libdir/lib%name-%api_ver.so
%_datadir/aclocal/%name.m4
%_datadir/aclocal/vapigen.m4
%exclude %_pkgconfigdir/vapigen*.pc
%exclude %_datadir/aclocal/vapigen.m4

%files doc
%_datadir/devhelp/books/%name-%api_ver

%files tools
%_bindir/vapigen
%_bindir/vapigen-%api_ver
%_bindir/vala-gen-introspect
%_bindir/vala-gen-introspect-%api_ver
# dropped in 0.39.91
#%_bindir/vapicheck
#%_bindir/vapicheck-%api_ver
%_pkgconfigdir/vapigen*.pc
%_datadir/aclocal/vapigen.m4
%_datadir/vala/Makefile.vapigen
%_libdir/vala-%api_ver/gen-introspect-%api_ver
%_man1dir/vala-gen-introspect*
%_man1dir/vapigen*

%files -n valadoc
%_bindir/valadoc
%_bindir/valadoc-%api_ver
%_libdir/libvaladoc-%api_ver.so.*
%dir %_libdir/valadoc-%api_ver
%dir %_libdir/valadoc-%api_ver/doclets
%_libdir/valadoc-%api_ver/doclets/devhelp/
%_libdir/valadoc-%api_ver/doclets/gtkdoc/
%_libdir/valadoc-%api_ver/doclets/html/
%_man1dir/valadoc*.1.*
%_datadir/valadoc-%api_ver/

%exclude %_libdir/valadoc-%api_ver/*/*/*.la

%files -n valadoc-devel
%_includedir/valadoc-%api_ver/
%_libdir/libvaladoc-%api_ver.so
%_pkgconfigdir/valadoc-%api_ver.pc
%_vapidir/valadoc-%api_ver.deps
%_vapidir/valadoc-%api_ver.vapi


%changelog
