Summary: A collection of basic system utilities
Name: util-linux
Version: 2.39.2
Release: alt2
License: GPL-2.0 and GPL-2.0-or-later and LGPL-2.1-or-later and BSD-3-Clause and BSD-4-Clause-UC and ALT-Public-Domain
Group: System/Base
URL: https://kernel.org/pub/linux/utils/util-linux/

### Macros
%def_enable uuidd
%def_with setarch
%def_enable runuser
%def_disable login
%def_disable sulogin
%def_disable su
%def_disable chfn_chsh
%def_disable newgrp
%def_disable vipw
%def_enable schedutils
%def_enable fsck
%def_with selinux
%def_with audit
%def_with udev
%def_without systemd
%def_enable line
%def_disable mountpoint
%def_disable eject
%ifarch armh %e2k loongarch64
%def_without klibc
%else
%def_with klibc
%endif

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%undefine __libtoolize

%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

### Dependences
BuildRequires: /proc,/dev/pts
BuildRequires: asciidoctor
BuildRequires: bash4
BuildRequires: glibc-devel-static
BuildRequires: zlib-devel
BuildRequires: libncursesw-devel
BuildRequires: libpopt-devel
BuildRequires: libcap-ng-devel
BuildRequires: python3-devel
%{?_with_selinux:BuildRequires: libselinux-devel}
%{?_with_audit:BuildRequires: libaudit-devel}
%{?_with_udev:BuildRequires: libudev-devel}
%{?_with_systemd:BuildRequires: libsystemd-devel}
%{?_enable_login:BuildRequires: libpam-devel}
%{?_enable_runuser:BuildRequires: libpam-devel}

%if_with klibc
BuildRequires: klibc-devel
%endif

### Sources
Source0: util-linux-%version.tar
Source1: util-linux-login.pamd
Source2: util-linux-runuser.pamd
Source3: util-linux-runuser-l.pamd
Source4: util-linux-chsh-chfn.pamd
Source5: mount.control
Source6: write.control
Source7: vol_id
Source8: nologin.c
Source9: nologin.8
Source10: pause.c
Source11: stacktest.c
Source12: clock_unsynced.c

### Obsoletes & Conflicts & Provides
Obsoletes: tunelp
Obsoletes: util-linux-ng
Obsoletes: util-linux-initramfs

Conflicts: initscripts <= 4.58, timeconfig <= 3.0.1
Provides: util-linux-ng = %version-%release

#for old kernels
Provides: /usr/sbin/rdev
Conflicts: kernel < 2.2.12-7

#due to fsck migration
%if_enabled fsck
Conflicts: e2fsprogs < 0:1.41.9-alt3
%endif

Requires(pre,post): %name-control = %version-%release
Requires: coreutils > 6.10-alt2
Requires: libsmartcols = %version-%release

#due to findmnt
Requires: libmount = %version-%release

Patch0001: 0001-ALT-Create-var-log-lastlog.patch
Patch0002: 0002-OWL-write-1-improvements.patch
Patch0003: 0003-ALT-Replace-vidattr-by-own-function-that-works-like-.patch
Patch0004: 0004-ALT-Do-not-accept-gecos-field-sizes-longer-than-64.patch
Patch0005: 0005-ALT-Allow-to-display-altlinux-release-in-the-message.patch
Patch0006: 0006-ALT-Drop-documentation-about-journald-option-since-w.patch

%description
The util-linux package contains a large variety of low-level system
utilities that are necessary for a Linux system to function. Among
others, Util-linux contains the fdisk configuration tool and the login
program.

%package control
Summary: Control scripts for %name and mount
Group: System/Base
BuildArch: noarch

%description control
This package contains control(8) scripts used by %name and mount packages.

%package -n lsblk
Summary: List block devices
Group: System/Base
Requires: libsmartcols = %version-%release

%description -n lsblk
lsblk lists information about all or the specified block devices.

%package -n mount
Summary: Programs for mounting and unmounting filesystems
Group: System/Base
Requires(pre,post): %name-control = %version-%release
Requires: libblkid = %version-%release
Requires: libmount = %version-%release
Requires: libsmartcols = %version-%release

%description -n mount
The %name package contains the mount, umount, swapon and swapoff
programs.  Accessible files on your system are arranged in one big
tree or hierarchy.  These files can be spread out over several
devices. The mount command attaches a filesystem on some device to
your system's file tree.  The umount command detaches a filesystem
from the tree.  Swapon and swapoff, respectively, specify and disable
devices and files for paging and swapping.

%package -n losetup
Summary: Programs for setting up and configuring loopback devices
Group: System/Base
Requires: libsmartcols = %version-%release

%description -n losetup
Linux supports a special block device called the loop device, which
maps a normal file onto a virtual block device.  This allows for the
file to be used as a "virtual file system" inside another file.
Losetup is used to associate loop devices with regular files or block
devices, to detach loop devices and to query the status of a loop device.

%package -n agetty
Summary: Alternative Linux getty
Group: System/Base
Requires: login

%description -n agetty
The alternative getty program for Linux.

%package -n cfdisk
Summary: The partitioning program with ncurses interface
Group: System/Configuration/Hardware
Requires: libblkid = %version-%release
Requires: libsmartcols = %version-%release

%description -n cfdisk
Small user-friendly ncurses-based partitioning program, which will help you
to partition your disk easily.

%package -n fdisk
Summary: The Partitioning Program
Group: System/Configuration/Hardware
Requires: libblkid = %version-%release
Requires: libsmartcols = %version-%release

%description -n fdisk
Small partitioning program with command line interface, that will be hard
for linux newbie, but it is extra stable, and you can trust it.

%package -n sfdisk
Summary: Partitioning program with argument interface
Group: System/Configuration/Hardware

%description -n sfdisk
Small partitioning program with argument interface, that will be hard
for linux newbie, but it is extra stable, and you can trust it.

%package -n hwclock
Summary: Query and set the hardware clock
Group: System/Base
Serial: 1
%ifarch alpha sparc sparc64
Obsoletes: clock
%endif

%description -n hwclock
Hwclock is a program that runs under Linux and sets and queries the
Hardware Clock, which is often called the Real Time Clock, RTC, or
CMOS clock.

You can set the Hardware Clock to a particular time or from the Linux
System Time.  You can set the Linux System Time from the Hardware
Clock, and a typical usage is to invoke Hwclock from a system startup
script to initialize the System Time.

Hwclock's --adjust function corrects systematic drift in the Hardware
Clock.  You just invoke it regularly and it corrects for a fast or
slow Hardware Clock.  Hwclock automatically computes how fast or slow
the Hardware Clock is every time you set it.

Hwclock uses /dev/rtc if it is available.  Otherwise, it uses its own
direct I/O to do what the rtc device driver would normally do.

%package -n getopt
Summary: An improved implementation of getopt
Group: System/Base

%description -n getopt
An improved implementation of getopt(1), a program to parse
options within a shell script. Fully compatible with other
getopt(1) implementations, but with many additions like
long options and mixing of options and parameters.

%package -n login
Summary: Start an interactive session on the system
Group: System/Base
Requires: pam >= 0.75-alt12

%description -n login
The login application opens an interactive session with a Linux workstation.
It is one of the first applications a user interacts with, but is generally
not invoked by a normal user.  Instead some program like mingetty(8) will
invoke login.

%package -n uuidd
Summary: Helper daemon to guarantee uniqueness of time-based UUIDs
Group: System/Servers
Requires: libuuid = %version-%release

%description -n uuidd
The uuidd package contains a userspace daemon (uuidd) which guarantees
uniqueness of time-based UUID generation even at very high rates on
SMP systems.

%package -n setarch
Summary: Personality setter
Group: System/Kernel and hardware
%ifarch sparc sparcv9 sparc64
Provides: sparc32
Obsoletes: sparc32
%endif

%description -n setarch
This utility tells the kernel to report a different architecture than
the current one, then runs a program in that environment.  It can also
set various personality flags.

%package -n schedutils
Summary: Utilities for manipulating process scheduler attributes
Group: System/Kernel and hardware

%description -n schedutils
schedutils is a set of utilities for retrieving and manipulating process
scheduler-related attributes, such as real-time parameters and CPU affinity.

This package includes the chrt and taskset utilities.

Install this package if you need to set or get scheduler-related attributes.

%package -n look
Summary: Program to display lines beginning with a given string
Group: System/Base
Requires: words

%description -n look
The look utility displays any lines in file which contain string as a prefix.

%package -n eject
Summary: A program that ejects removable media using software control
Group: System/Kernel and hardware

%description -n eject
Eject  allows  removable  media (typically a CD-ROM, floppy disk, tape,
JAZ, ZIP or USB disk) to be ejected under software control.   The  command
can  also control some multi-disc CD-ROM changers, the auto-eject feature
supported by some devices, and close the disc tray of some  CD-ROM drives.

%package -n rfkill
Summary: A tool to use /dev/rfkill
Group: Networking/Other

%description -n rfkill
rfkill is a small tool to query the state of the rfkill switches,
buttons and subsystem interfaces.

%package -n libblkid
Summary: Dynamic block device id library
Group: System/Libraries
Requires: libuuid = %version-%release

%description -n libblkid
The blkid library which allows system programs like fsck and mount to
quickly and easily find block devices by filesystem UUID and LABEL.

%package -n libblkid-devel
Summary: Development block device id library and include files
Group: Development/C
Requires: libblkid = %version-%release

%description -n libblkid-devel
This package contains the library and include files needed to develop
libblkid-based software.

%package -n libblkid-devel-static
Summary: Static block device id library
Group: Development/C
Requires: libblkid-devel = %version-%release
Requires: libuuid-devel-static

%description -n libblkid-devel-static
This package contains the library and include files needed to develop
statically linked libblkid-based software.

%package -n libuuid
Summary: Dynamic universally unique id library
Group: System/Libraries

%description -n libuuid
The uuid library generates and parses 128-bit universally unique id's
(UUID's).  See RFC 4122 for more information.

%package -n libuuid-devel
Summary: Development universally unique id library and include files
Group: Development/C
Requires: libuuid = %version-%release

%description -n libuuid-devel
This package contains the library and include files needed to develop
libuuid-based software.

%package -n libuuid-devel-static
Summary: Static block device id library
Group: Development/C
Requires: libuuid-devel = %version-%release

%description -n libuuid-devel-static
This package contains the library and include files needed to develop
statically linked libuuid-based software.

%package -n libmount
Summary: Device mounting library
Group: System/Libraries
Requires: libblkid = %version-%release

%description -n libmount
This is the device mounting library, part of util-linux-ng.

%package -n libmount-devel
Summary: Device mounting library
Group: Development/C
Requires: libmount = %version-%release

%description -n libmount-devel
This is the device mounting development library and headers,
part of util-linux-ng.

%package -n libmount-devel-static
Summary: Device mounting static library
Group: Development/C
Requires: libmount-devel = %version-%release

%description -n libmount-devel-static
This is the device mounting development static library.

%package -n python3-module-libmount
Summary: Python bindings for the libmount library
Group: Development/Python3
Requires: libmount = %version-%release

%description -n python3-module-libmount
This package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libmount library to work with mount tables (fstab,
mountinfo, etc) and mount filesystems.

%package -n libsmartcols
Summary: table or tree library
Group: System/Libraries

%description -n libsmartcols
The libsmartcols library is used for smart adaptive formatting of tabular data.

%package -n libsmartcols-devel
Summary: table or tree library
Group: Development/C
Requires: libsmartcols = %version-%release

%description -n libsmartcols-devel
This is the smartcols development library and headers,
part of util-linux-ng.

%package -n libsmartcols-devel-static
Summary: Table or tree static library
Group: Development/C
Requires: libsmartcols-devel = %version-%release

%description -n libsmartcols-devel-static
This is the smartcols development static library.

%package -n libfdisk
Summary: Partitioning library for fdisk-like programs.
Group: System/Libraries
License: LGPL-2.1-or-later

%description -n libfdisk
This is library for fdisk-like programs, part of util-linux.

%package -n libfdisk-devel
Summary:  Partitioning library for fdisk-like programs.
Group: Development/C
License: LGPL-2.1-or-later
Requires: libfdisk = %version-%release
Requires: pkgconfig

%description -n libfdisk-devel
This is development library and headers for fdisk-like programs,
part of util-linux.

%package -n libfdisk-devel-static
Summary:  Partitioning library for fdisk-like programs.
Group: Development/C
License: LGPL-2.0-or-later
Requires: libfdisk = %version-%release
Requires: pkgconfig

%description -n libfdisk-devel-static
This is development static library for fdisk-like programs,
part of util-linux.

%package -n bash-completion-%name
Summary: Bash completion for %name utils
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: %name = %version-%release

%description -n bash-completion-%name
Bash completion for %name.

%package -n hardlink
Summary: Consolidate duplicate files via hardlinks
Group: System/Base

%description -n hardlink
This package contains hardlink, an utility which consolidates duplicate
files in one or more directories using hardlinks.

hardlink traverses one or more directories searching for duplicate files.
When it finds duplicate files, it uses one of them as the master.  It then
removes all other duplicates and places a hardlink for each one pointing
to the master file.  This allows for conservation of disk space where
multiple directories on a single filesystem contain many duplicate files.

Since hard links can only span a single filesystem, hardlink is only
useful when all directories specified are on the same filesystem.

%prep
%setup -q
%autopatch -p1

cp -r -- %SOURCE8 %SOURCE9 %SOURCE10 %SOURCE11 %SOURCE12 .

echo %version > .tarball-version

mkdir -p rpm
cp -- %SOURCE7 rpm/

%build
#add_optflags %(getconf LFS_CFLAGS) -D_LARGEFILE64_SOURCE
export HAS_GTKDOC=1
export runstatedir="%_runtimedir"

po/update-potfiles
autopoint --force
libtoolize --force
aclocal --force -I m4
autoconf --force
autoheader --force
automake --add-missing --force-missing

%configure \
	--bindir=/bin \
	--sbindir=/sbin \
	--disable-kill \
	--disable-wall \
	--disable-arch \
	--disable-last \
	--disable-mesg \
	--disable-chfn-chsh \
	--with-python=3 \
	--enable-partx \
	--enable-write \
	--enable-rdev \
	%{subst_enable runuser} \
	%{subst_enable login} \
	%{subst_enable sulogin} \
	%{subst_enable su} \
	%{?_enable_chfn_chsh:--enable-chfn-chsh} \
	%{subst_enable newgrp} \
	%{subst_enable vipw} \
	%{subst_enable schedutils} \
	--enable-libsmartcols \
	--enable-libblkid \
	--enable-libuuid \
	%{subst_enable fsck} \
	%{subst_enable uuidd} \
	%{subst_with udev} \
	%{subst_with selinux} \
	%{subst_with audit} \
	%{subst_with systemd} \
	%{subst_enable line} \
	%{subst_enable mountpoint} \
	%{subst_enable eject} \
	--enable-ddate \
	--disable-makeinstall-chown

# build util-linux-ng
%make_build

%ifarch %ix86 x86_64
%__cc %optflags -no-pie stacktest.c -o stacktest
%endif

# build nologin
%if_with klibc
klcc \
%else
%__cc -static \
%endif
	-Wall -Wextra -Werror nologin.c -o nologin

%__cc %optflags clock_unsynced.c -o clock_unsynced
%__cc %optflags pause.c -o pause


%check
rm  -f -- tests/ts/fadvise/drop
rm  -f -- tests/ts/ipcs/limits
rm  -f -- tests/ts/ipcs/limits2
rm  -f -- tests/ts/libmount/lock
rm  -f -- tests/ts/libmount/utils
rm  -f -- tests/ts/lsfd/option-inet
rm  -f -- tests/ts/lsns/ioctl_ns
rm  -f -- tests/ts/misc/ionice
rm  -f -- tests/ts/misc/setarch
rm -rf -- tests/ts/fincore
rm -rf -- tests/ts/login
rm -rf -- tests/ts/look
rm -rf -- tests/ts/lsblk

# The default is sha256, or memcmp if Linux Crypto API is not available.
sed -i -e 's#sha256#memcmp#g' tests/expected/hardlink/options-maximum-size-819{1,2}

LANG=C %make check

%install
mkdir -p %buildroot/{bin,sbin,etc/pam.d}
mkdir -p %buildroot/{%_bindir,%_sbindir,%_libdir,%_infodir,%_mandir/man{1,6,5,8}}

# install util-linux-ng
%make_install install DESTDIR=%buildroot

install -pD -m755 %SOURCE5 %buildroot%_controldir/mount
install -pD -m755 %SOURCE6 %buildroot%_controldir/write

%ifarch %ix86 x86_64
install -p -m755 stacktest %buildroot/%_bindir
%endif
install -p -m755 pause %buildroot/%_bindir
install -p -m755 nologin %buildroot/sbin/
install -p -m644 nologin.8 %buildroot/%_man8dir/

%if_enabled runuser
	install -m 644 %SOURCE2 %buildroot/%_sysconfdir/pam.d/runuser
	install -m 644 %SOURCE3 %buildroot/%_sysconfdir/pam.d/runuser-l
%endif
%if_enabled chfn_chsh
	chmod 4711 %buildroot/%_bindir/{ch{sh,fn}
	install -m 644 %SOURCE4 %buildroot/%_sysconfdir/pam.d/chsh
	install -m 644 %SOURCE4 %buildroot/%_sysconfdir/pam.d/chfn
%endif
%if_enabled newgrp
	chmod 4711 %buildroot/%_bindir/newgrp
%endif

	install -pD -m755 clock_unsynced %buildroot/bin/clock_unsynced
	ln -sf ../../sbin/hwclock %buildroot/%_sbindir/hwclock
	ln -sf hwclock %buildroot/sbin/clock
	mkdir -p -- %buildroot/%_localstatedir/hwclock
	install -pD -m644 /dev/null %buildroot/%_localstatedir/hwclock/lastdate
	install -pD -m644 /dev/null %buildroot/%_sysconfdir/adjtime

# deprecated commands
for prog in \
	/sbin/fsck.minix /sbin/mkfs.{bfs,minix} /sbin/sln /sbin/shutdown /bin/kill \
	%_bindir/newgrp \
	\
	%_man1dir/newgrp.1 \
	%_man8dir/fsck.minix.8 %_man8dir/mkfs.minix.8 %_man8dir/mkfs.bfs.8 \
	\
	%_datadir/getopt;
do
	rm -rf -- %buildroot/$prog
done

# we install getopt/getopt-*.{bash,tcsh} as doc files
chmod 644 misc-utils/getopt-*.{bash,tcsh}

# Relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p -- %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

# /sbin -> /usr/sbin
for I in cfdisk; do
	[ ! -e %buildroot/sbin/$I ] ||
		mv -- %buildroot/sbin/$I %buildroot/%_sbindir/$I
done

# /usr/sbin -> /sbin
for I in addpart delpart partx; do
	[ ! -e %buildroot/%_sbindir/$I ] ||
		mv -- %buildroot/%_sbindir/$I %buildroot/sbin/$I
done

# /usr/bin -> /bin
for I in getopt taskset; do
	[ -e %buildroot/%_bindir/$I ] ||
		continue
	mv -- %buildroot/%_bindir/$I %buildroot/bin/$I
	path="$(relative "%buildroot/bin/$I" "%buildroot/%_bindir/$I")"
	ln -s "$path" %buildroot/%_bindir/$I
done

%if_without systemd
install -pD -m644 sys-utils/fstrim.timer   %buildroot/%_unitdir/fstrim.timer
sed 's,@sbindir@,/sbin,' < sys-utils/fstrim.service.in > %buildroot/%_unitdir/fstrim.service
%endif

LINKS="linux32 linux64"
%ifarch s390 s390x
	LINKS="$LINKS s390 s390x"
%endif
%ifarch %ix86 x86_64 amd64 ia32e
	LINKS="$LINKS i386 i486 i586 i686 x86_64"
%endif
%ifarch ppc ppc64
	LINKS="$LINKS ppc ppc64 ppc32"
%endif
%ifarch sparc sparc64
	LINKS="$LINKS sparc sparc64 sparc32"
%endif
%ifarch mips mips64
	LINKS="$LINKS mips mips64 mips32"
%endif
%ifarch ia64
	LINKS="$LINKS i386 ia64"
%endif

exclude_archs='setarch'
for i in $LINKS; do
	exclude_archs="$exclude_archs|$i"

%if_with setarch
	ln -sf -- setarch %buildroot/%_bindir/$i
	echo '.so man8/setarch.8' > %buildroot/%_man8dir/$i.8
	echo "%_bindir/$i"
	echo "%_man8dir/$i.8.*"
%endif #with setarch
done > setarch.files

%if_enabled uuidd
	:> uuidd.files

	ls -1 %buildroot/%_sbindir |
		egrep '^uuidd$' |
		sed -e 's|^\(.*\)$|%%_sbindir/\1|g' \
		>> uuidd.files

	ls -1 %buildroot%_man8dir |
		egrep '^uuidd\.' |
		sed -e 's|^\(.*\)$|%%_man8dir/\1*|g' \
		>> uuidd.files

	ls -1 %buildroot%_unitdir |
		egrep '^uuidd\.*' |
		sed -e 's|^\(.*\)$|%%_unitdir/\1|g' \
		>> uuidd.files

%endif #enabled uuidd

{
	# bindir
	ls -1 %buildroot/%_bindir |
		egrep -v "^($exclude_archs)\$" |
		egrep -v '^(eject|write|getopt|look|taskset|chrt|ionice|hardlink)$' |
		sed -e 's|^\(.*\)$|%%_bindir/\1|g'

	# sbindir
	ls -1 %buildroot/%_sbindir |
		egrep -v '(fdisk|hwclock|uuidd|rfkill)' |
    		sed -e 's|^\(.*\)$|%%_sbindir/\1|g'

	# man1dir
	ls -1 %buildroot%_man1dir |
		egrep -v '^(eject|getopt|login|look|taskset|chrt|ionice|hardlink)' |
		sed -e 's|^\(.*\)$|%%_man1dir/\1*|g'

	# man5dir
	ls -1 %buildroot%_man5dir |
		egrep    '^(terminal-colors\.d)' |
		sed -e 's|^\(.*\)$|%%_man5dir/\1*|g'

	# man8dir
	ls -1 %buildroot%_man8dir |
		egrep -v "^($exclude_archs)\.8*\$" |
		egrep -v '(mount|^swapo|losetup|lsblk|clock|getty|fdisk|part|uuidd|rfkill)' |
		sed -e 's|^\(.*\)$|%%_man8dir/\1*|g'

	# unitdir
	ls -1 %buildroot%_unitdir |
		egrep -e '^(fstrim\.*)' |
		sed -e 's|^\(.*\)$|%%_unitdir/\1|g'

	# /bin
	ls -1 %buildroot/bin |
		egrep -v '(getopt|login|lsblk|mount|taskset|clock_unsynced)' |
		sed -e 's|^\(.*\)$|/bin/\1|g'

	# /sbin
	ls -1 %buildroot/sbin |
		egrep -v '(^swapo|^losetup|addpart|delpart|partx|clock|getty|fdisk)' |
		sed -e 's|^\(.*\)$|/sbin/\1|g'
} > %name.files

ln -s /proc/mounts %buildroot/etc/mtab

# omit info/dir file
rm -f -- %buildroot/%_infodir/dir

# remove getopt docs
rm -rf -- %buildroot/%_defaultdocdir/%name/getopt{,-example.{bash,tcsh}}

mkdir -p %buildroot/lib/tmpfiles.d
cat > %buildroot/lib/tmpfiles.d/losetup-loop.conf <<EOF
b /dev/loop0 0660 root disk - 7:0
b /dev/loop1 0660 root disk - 7:1
b /dev/loop2 0660 root disk - 7:2
b /dev/loop3 0660 root disk - 7:3
EOF

# find MO files
%find_lang %name
cat %name.lang >> %name.files

%triggerpostun -n hwclock -- startup <= 0.6-alt1, initscripts < 1:5.49.1-alt1
f=%_sysconfdir/adjtime
if [ ! -f "$f" ]; then
    if [ -f "$f".rpmsave ]; then
        cp -pf "$f".rpmsave "$f"
    elif [ -f "$f".rpmnew ]; then
        cp -pf "$f".rpmnew "$f"
    fi
fi

%pre
%pre_control write

%post
%post_control write

%pre -n mount
%pre_control mount

%post -n mount
%post_control mount

%files control
%config %_controldir/mount
%config %_controldir/write

%files -n lsblk
/bin/lsblk
%_man8dir/lsblk.*

%files -n mount
/etc/mtab
%attr(700,root,root) /bin/mount
%attr(700,root,root) /bin/umount
/sbin/swapo*
%_man5dir/fstab.*
%_man8dir/*mount*
%_man8dir/swapo*

%files -n losetup
/sbin/losetup
%_man8dir/losetup*
/lib/tmpfiles.d/losetup-loop.conf

%files -n hwclock
%config(noreplace) %_sysconfdir/adjtime
%config(noreplace) %_localstatedir/hwclock/lastdate
/bin/clock_unsynced
/sbin/*clock
%_sbindir/hwclock
%dir %_localstatedir/hwclock
%_man5dir/adjtime_config.5*
%_man8dir/*clock.*
%doc Documentation/hwclock.txt

%files -n getopt
/bin/getopt
%_bindir/getopt
%_man1dir/getopt.*
%doc misc-utils/getopt-*.{bash,tcsh}

%files -n agetty
/sbin/agetty
%_man8dir/agetty.*
%doc Documentation/modems-with-agetty.txt

%files -n cfdisk
%_sbindir/cfdisk
%_man8dir/cfdisk.*

%files -n fdisk
/sbin/fdisk
/sbin/*part*
%_man8dir/fdisk.*
%_man8dir/*part*.*

%files -n sfdisk
/sbin/sfdisk
%_man8dir/sfdisk.*

%files -n look
%_bindir/look
%_man1dir/look.*

%files -n rfkill
%_sbindir/rfkill
%_man8dir/rfkill.*

%if_enabled login
%files -n login
/bin/login
%_man8dir/login.8*
%config(noreplace) %_sysconfdir/pam.d/login
%config(noreplace) %_sysconfdir/pam.d/ch??
%endif #enabled login

%if_enabled schedutils
%files -n schedutils
/bin/taskset
%_bindir/chrt
%_bindir/ionice
%_bindir/taskset
%_man1dir/chrt.*
%_man1dir/ionice.*
%_man1dir/taskset.*
%endif #enabled schedutils

%if_with setarch
%files -n setarch -f setarch.files
%_bindir/setarch
%_man8dir/setarch.*
%endif #with setarch

%if_enabled eject
%files -n eject
%_bindir/eject
%_man1dir/eject.1*
%endif #enabled eject

%files -n libblkid
/%_lib/libblkid.so.*

%files -n libblkid-devel
%_includedir/blkid
%_pkgconfigdir/blkid.pc
%_libdir/libblkid.so
%_man3dir/libblkid.*

%files -n libblkid-devel-static
%_libdir/libblkid.a

%files -n libuuid
/%_lib/libuuid.so.*

%files -n libuuid-devel
%_includedir/uuid
%_pkgconfigdir/uuid.pc
%_libdir/libuuid.so
%_man3dir/uuid*

%files -n libuuid-devel-static
%_libdir/libuuid.a

%if_enabled uuidd
%files -n uuidd -f uuidd.files
%endif #with uuidd

%files -n libmount
/%_lib/libmount.so.*

%files -n libmount-devel
%_includedir/libmount
%_libdir/libmount.so
%_pkgconfigdir/mount.pc

%files -n libmount-devel-static
%_libdir/libmount.a

%files -n python3-module-libmount
%python3_sitelibdir/libmount/

%files -n libsmartcols
/%_lib/libsmartcols.so.*

%files -n libsmartcols-devel
%_includedir/libsmartcols
%_libdir/libsmartcols.so
%_pkgconfigdir/smartcols.pc

%files -n libsmartcols-devel-static
%_libdir/libsmartcols.a

%files -n libfdisk
/%_lib/libfdisk.so.*

%files -n libfdisk-devel
%_includedir/libfdisk
%_libdir/libfdisk.so
%_pkgconfigdir/fdisk.pc

%files -n libfdisk-devel-static
%_libdir/libfdisk.a

%files -n bash-completion-%name
%_datadir/bash-completion/completions/*

%files -n hardlink
%_bindir/hardlink
%_man1dir/hardlink.*

%files -f %name.files
%if_enabled runuser
%config(noreplace) %_sysconfdir/pam.d/runuser
%config(noreplace) %_sysconfdir/pam.d/runuser-l
%endif
%attr(700,root,tty) %_bindir/write
%doc Documentation/*.txt NEWS AUTHORS README* Documentation/licenses/* Documentation/TODO

%changelog
