Name: u-boot-meson
Version: 2025.10
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: https://docs.u-boot.org/en/latest/

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

Source: %name-%version-%release.tar

BuildRequires: aarch64-none-elf-gcc
BuildRequires: bc ccache dtc >= 1.7 flex libgnutls-devel libssl-devel libuuid-devel

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various AMLogic Meson family boards.

%prep
%setup
sed -e '/^CONFIG_DEFAULT_DEVICE_TREE/ s,gsking-x,ugoos-am6,' \
    -e '/^CONFIG_IDENT_STRING/ s,beelink,ugoos-am6,' \
    < configs/beelink-gsking-x_defconfig > configs/ugoos-am6_defconfig

%build
export DTC=%_bindir/dtc
export CROSS_COMPILE=aarch64-none-elf-
boards=$(grep -lr ARCH_MESON configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do
	O=build/${board}
	%make_build HOSTCC='ccache gcc' O=${O} ${board}_defconfig all
	install -pm0644 -D ${O}/u-boot.bin out/${board}/u-boot.bin
done

%install
mkdir -p %buildroot%_datadir/u-boot
cp -a out/* %buildroot%_datadir/u-boot

%files
%doc README doc/board/amlogic
%_datadir/u-boot/*

%changelog
