# FIXME: Something wrong in x86 tests. Check out during further update.
%ifarch %ix86
%def_without check
%else
%def_with check
%endif

Name:    typst
Version: 0.14.0
Release: alt1

Summary: New markup-based typesetting system that is powerful and easy to learn
License: Apache-2.0
Group:   Text tools
Url:     https://typst.app
Vcs:     https://github.com/typst/typst.git

Source0: %name-%version.tar
Source1: vendor.tar

BuildRequires(pre): rpm-build-rust
BuildRequires: libssl-devel
BuildRequires: rust-cargo /proc
# BuildRequires: cargo-vendor-filterer

%description
Typst is a new markup-based typesetting system that is designed to be
as powerful as LaTeX while being much easier to learn and use.

Typst has
- Built-in markup for the most common formatting tasks
- Flexible functions for everything else
- A tightly integrated scripting system
- Math typesetting, bibliography management, and more
- Fast compile times thanks to incremental compilation
- Friendly error messages in case something goes wrong

%package -n bash-completion-%name
Summary:        Bash completion routines for %name
Group:          Shells
BuildArch:      noarch
Requires:       %name
Requires:       bash-completion

%description -n bash-completion-%name
Bash command-line completion support for %name.

%prep
%setup -a 1
mkdir -p .cargo
cat >> .cargo/config.toml <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source."git+https://github.com/typst/typst-dev-assets?tag=v%version"]
git = "https://github.com/typst/typst-dev-assets"
tag = "v%version"
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "vendor"

[term]
verbose = true
quiet = false

[install]
root = "%buildroot%_prefix"

[build]
rustflags = ["-Copt-level=3", "-Cdebuginfo=1"]

[profile.release]
strip = false
EOF

%build
export GEN_ARTIFACTS=artifacts
export 'RUSTFLAGS= -g'
# Reduce build jobs count for i586 arch to avoid OOM.
%ifarch %ix86
export NJOBS='-j4'
%else
export NJOBS=%{?_smp_mflags}
%endif
cargo build --release $NJOBS --offline

%install
%rust_install
install -dv %buildroot{%_man1dir,%_datadir/bash-completion/completions}
install -m644 -v ./crates/%name-cli/artifacts/%{name}*.1 %buildroot%_man1dir
install -m644 -v ./crates/%name-cli/artifacts/%name.bash \
%buildroot%_datadir/bash-completion/completions

%check
%rust_test --workspace

%files
%doc *.md LICENSE NOTICE docs/{guides,tutorial}
%_bindir/%name
%_man1dir/*.1.*

%files -n bash-completion-%name
%_datadir/bash-completion/completions/%name.bash

%changelog
