Name: tuxpaint-config
Version: 0.0.26
Release: alt1

Summary: Configuration tool for Tux Paint

URL: https://www.tuxpaint.org
License: GPLv2+
Group: Graphics
Requires: tuxpaint

Source: %name-%version.tar
Patch1: tuxpaint-config-docpath.patch
Patch2: tuxpaint-config-desktop.patch
# Automatically added by buildreq on Wed Mar 20 2013
# optimized out: fontconfig libX11-devel libXext-devel libstdc++-devel xorg-xproto-devel
BuildRequires: gcc-c++ libXft-devel libXinerama-devel libcairo-devel libfltk-devel libpaper-devel libpixman-devel

BuildRequires: libXfixes-devel libXcursor-devel libunibreak5-devel libpango-devel

%description
Tux Paint has a rich set of configuration options, controllable via
command-line options or configuration files. This configuration tool
provides a point-and-click interface for administrators to tailor
Tux Paint to suit the needs of their users.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%make_build PREFIX=%prefix X11_ICON_PREFIX=/usr/include/X11/pixmaps/

%install
mkdir -p %buildroot%_bindir
%make PREFIX=%buildroot%prefix X11_ICON_PREFIX=%buildroot%_includedir/X11/pixmaps/ DOC_PREFIX=%buildroot%_defaultdocdir/%name install
install -pDm644 src/%name.desktop %buildroot%_desktopdir/%name.desktop

# fix file permissions
find %buildroot%_defaultdocdir/%name -type f -exec chmod 644 {} \;
find %buildroot%_mandir -type f -exec chmod 644 {} \;

%find_lang %name

%files -f %name.lang
%_bindir/tuxpaint-config
%doc %_defaultdocdir/%name
%dir %_includedir/X11/pixmaps
%_includedir/X11/pixmaps/tuxpaint-config.xpm
%_man1dir/*
%_datadir/tuxpaint-config/
%_pixmapsdir/*.png
%_desktopdir/*.desktop
%_datadir/icons/hicolor/*/apps/%name.png

%changelog
