Name: tuxguitar
Version: 1.6.6
Release: alt1

Summary: A multitrack guitar tablature editor and player
License: LGPL-2.0+
Group: Sound

Url: https://www.tuxguitar.app/
VCS: https://github.com/helge17/tuxguitar

Source0: %name-%version.tar
Source1: vendors-%version.tar
Source2: tuxguitar.sh

Requires: java-17-openjdk
Requires: javapackages-filesystem
BuildRequires: java-17-openjdk-devel java-headless
BuildRequires: javapackages-filesystem maven glibc libfluidsynth-devel
BuildRequires: libjack-devel libalsa-devel soundfont2-default gcc-c++
BuildRequires: lilv-devel musl-devel libconfig-devel libsuil-devel
BuildRequires: qt5-base-devel libfreetype-devel
BuildRequires: libxcbutil-devel libXdmcp-devel libxcbutil-cursor-devel
BuildRequires: libxcbutil-keysyms-devel libxkbcommon-x11-devel libpango-devel
BuildRequires: libgtkmm2-devel libgtkmm3-devel libstdc++-devel

ExclusiveArch: x86_64

%description
TuxGuitar is a guitar tablature editor with player support through midi.
It can display scores and multitrack tabs. It can open GP3, GP3 and GP5
files.

With TuxGuitar, you will be able to compose music using the following features:
* Tablature editor
* Score Viewer
* Multitrack display
* Autoscroll while playing
* Note duration management
* Various effects (bend, slide, vibrato, hammer-on/pull-off)
* Support for triplets (5,6,7,9,10,11,12)
* Repeat open and close
* Time signature management
* Tempo management
* Imports and exports gp3,gp4 and gp5 files

%prep
%setup -n vendors-%version -b 1
%setup -n %name-%version

%build
pushd desktop/build-scripts/tuxguitar-linux-swt
mvn -P native-modules package -Dmaven.repo.local=../../../vendors/m2-repository
popd

%install
mkdir -p %buildroot/%_bindir
mkdir -p %buildroot/%_datadir/%name-%version/
mkdir -p %buildroot/%_libdir/%name-%version/

install -pm 755 %SOURCE2 %buildroot/%_bindir/tuxguitar

cp -r desktop/build-scripts/tuxguitar-linux-swt/target/tuxguitar-9.99-SNAPSHOT-linux-swt/dist/ %buildroot/%_datadir/%name-%version/
cp -r desktop/build-scripts/tuxguitar-linux-swt/target/tuxguitar-9.99-SNAPSHOT-linux-swt/share/ %buildroot/%_datadir/%name-%version/
cp -r desktop/build-scripts/tuxguitar-linux-swt/target/tuxguitar-9.99-SNAPSHOT-linux-swt/lib/ %buildroot/%_libdir/%name-%version/

# desktop files
install -dm 755 %buildroot/%_datadir/applications
sed 's/Icon=tuxguitar/Icon=\/usr\/share\/icons\/hicolor\/96x96\/apps\/tuxguitar.png/g' %buildroot/%_datadir/%name-%version/share/applications/tuxguitar.desktop > %buildroot/%_datadir/applications/tuxguitar.desktop

# icon
install -dm 755 %buildroot/%_iconsdir/hicolor/96x96/apps/
install -pm 644 desktop/TuxGuitar/share/skins/Lavender/icon.png %buildroot/%_iconsdir/hicolor/96x96/apps/tuxguitar.png

# mime-type icons
install -dm 755 %buildroot/%_iconsdir/hicolor/96x96/mimetypes
install -pm 644 desktop/TuxGuitar/share/skins/Lavender/icon.png %buildroot/%_iconsdir/hicolor/96x96/mimetypes/audio-x-tuxguitar.png
install -pm 644 desktop/TuxGuitar/share/skins/Lavender/icon.png %buildroot/%_iconsdir/hicolor/96x96/mimetypes/audio-x-gtp.png
install -pm 644 desktop/TuxGuitar/share/skins/Lavender/icon.png %buildroot/%_iconsdir/hicolor/96x96/mimetypes/audio-x-ptb.png

desktop-file-install --dir %buildroot/%_datadir/applications --delete-original %buildroot/%_datadir/applications/tuxguitar.desktop

# mime-type file
install -dm 755 %buildroot/%_datadir/mime/packages
install -pm 644 desktop/build-scripts/tuxguitar-linux-swt/target/tuxguitar-9.99-SNAPSHOT-linux-swt/share/mime/packages/tuxguitar.xml %buildroot/%_datadir/mime/packages/

%pretrans -p <lua>
path = "%{_iconsdir}/hicolor/96x96/apps/tuxguitar.png"
st = posix.stat(path)
if st and st.type == "directory" then
  if posix.stat(path .. "/icon.png") then
    os.remove(path .. "/icon.png")
  end
  os.remove(path)
end

%files
%doc AUTHORS LICENSE README.md
%_libdir/tuxguitar-%version
%_datadir/tuxguitar-%version
%_iconsdir/hicolor/*/*/*
%_datadir/applications/tuxguitar.desktop
%_datadir/mime/packages/*.xml
%_bindir/tuxguitar

%changelog
