%define		real_version	1.8beta5
Name:		tsocks
Version:	1.8
Release:	alt2
Summary:	Library for catching network connections, redirecting them on a SOCKS server
Group:		Security/Networking
License:	GPLv2+
URL:		http://tsocks.sourceforge.net/
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{real_version}.tar
Source1:        %name.sh
Patch0:		tsocks_remove_static_lib.patch
Patch1:		tsocks_fix_lib_path.patch
Patch2:		tsocks_script_validation_error.patch
Patch3:		tsocks_documentation_update.patch

%description
tsocks is designed for use in machines which are firewalled from the
Internet. It avoids the need to recompile applications like lynx or
telnet so they can use SOCKS to reach the Internet. It behaves much
like the SOCKSified TCP/IP stacks seen on other platforms.

tsocks is a library to allow transparent SOCKS proxying. It wraps the
normal connect() function. When a connection is attempted, it consults
the configuration file (which is defined at configure time but defaults
to /etc/tsocks.conf) and determines if the IP address specified is local.
If it is not, the library redirects the connection to a SOCKS server
specified in the configuration file. It then negotiates that connection
with the SOCKS server and passes the connection back to the calling
program.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
#patch2 -p1
%patch3 -p1

%build
%autoreconf
%configure
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT
install %SOURCE1 %buildroot%_bindir/%name

%files
%defattr(-,root,root,-)
%doc ChangeLog COPYING FAQ TODO tsocks.conf.simple.example tsocks.conf.complex.example
%_bindir/*
%_libdir/libtsocks*
%_mandir/man?/*

%changelog
