%global import_path github.com/aquasecurity/trivy
%global _unpackaged_files_terminate_build 1

%ifdef _priority_distbranch
%define altbranch %_priority_distbranch
%else
%define altbranch %(rpm --eval %%_priority_distbranch)
%endif
%if "%altbranch" == "%nil"
%define altbranch sisyphus
%endif

Name: trivy
Version: 0.66.0
Release: alt1
Summary: A Fast Vulnerability Scanner for Containers

Group: Monitoring
License: Apache-2.0
Url: https://%import_path

Source: %name-%version.tar
Source2: %name.service
Source3: %name.sysconfig

ExclusiveArch:  %go_arches

BuildRequires(pre): rpm-macros-systemd rpm-macros-golang
BuildRequires: rpm-build-golang wire golang >= 1.24.4

BuildRequires: /proc

%description
Trivy is a comprehensive and versatile security scanner.
Trivy has scanners that look for security issues, and targets where it can
find those issues.

Targets (what Trivy can scan):
* Container Image
* Filesystem
* Git Repository (remote)
* Virtual Machine Image
* Kubernetes
* AWS

Scanners (what Trivy can find there):
* OS packages and software dependencies in use (SBOM)
* Known vulnerabilities (CVEs)
* IaC issues and misconfigurations
* Sensitive information and secrets
* Software licenses

%package server
Summary: Trivy local server
Group: System/Servers
BuildArch: noarch
Requires: trivy-db

%description server
%summary.

%prep
%setup

%build
# replace default node-collector image source
sed -i 's|ghcr.io/aquasecurity/node-collector|registry.altlinux.org/%altbranch/trivy-node-collector|g' \
    pkg/flag/kubernetes_flags.go \
    vendor/github.com/aquasecurity/trivy-kubernetes/pkg/jobs/template/node-collector.yaml

# replace default trivy-db image source
#find . -type f -exec \
#	sed -i "s/ghcr.io\/aquasecurity\/trivy-db/registry.altlinux.org\/alt\/trivy-db/g" {} +

# replace default trivy-checks image source
#find . -type f -exec \
#	sed -i "s/ghcr.io\/aquasecurity\/trivy-checks/registry.altlinux.org\/alt\/trivy-checks/g" {} +

export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export LDFLAGS="-X github.com/aquasecurity/trivy/pkg/version/app.ver=%version"
export CGO_ENABLED=0

%golang_prepare
wire gen pkg/commands/... pkg/rpc/... pkg/k8s/...
%golang_build cmd/trivy

%install
export BUILDDIR="$PWD/.gopath"
mkdir -p %buildroot{%_bindir,%_sysconfdir/sysconfig,%_unitdir}

%golang_install

install -m 0644 %SOURCE2 %buildroot%_unitdir/%name.service
install -m 0644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name

rm -rf -- %buildroot%_datadir
rm -rf -- %buildroot%go_root

%post server
%post_systemd_postponed %name

%preun server
%preun_systemd %name

%files
%doc LICENSE README.md docs
%_bindir/%name

%files server
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/sysconfig/%name

%changelog
