%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: tripso
Version: 1.2.2
Release: alt2

Summary: Translation of IPv4 Security Options (IPSO) Labels
License: GPL-2.0-only
Group: System/Kernel and hardware
Requires: iptables

Url: https://github.com/vt-alt/tripso
Source0: %name-%version.tar

BuildRequires(pre): rpm-build-kernel
BuildRequires: libiptables-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: figlet
BuildRequires: iproute2
BuildRequires: iptables
BuildRequires: kernel-headers-modules-%kernel_latest
BuildRequires: kernel-%kernel_latest
BuildRequires: net-tools
BuildRequires: rpm-build-vm
BuildRequires: tcpdump
BuildRequires: tcpreplay
}}

%description
Translate between CISPO and GOST R 58256-2018 security labels (userspace part).

%package -n kernel-source-%name
Summary: Translate between CISPO and GOST R 58256-2018 security labels (source)
Group: Development/Kernel
BuildArch: noarch
%description -n kernel-source-%name
Translate between CISPO and GOST R 58256-2018 security labels (source).

%prep
%setup

%build
make libxt_TRIPSO.so VERSION=%version CFLAGS="%optflags"

%install
make install-lib DESTDIR=%buildroot
install -pDm0644 %_sourcedir/%name-%version.tar %kernel_srcdir/kernel-source-%name-%version.tar

%check
VERSION=%version ./check.sh

%files -n kernel-source-%name
%attr(0644,root,root) %kernel_src/kernel-source-%name-%version.tar

%files
%doc README.md
/%_lib/iptables/*.so

%changelog
