Name: tree-sitter
Version: 0.25.10
Release: alt1

Summary: Parser generator tool and an incremental parsing library
License: MIT
Group: Development/Tools

Url: https://github.com/tree-sitter/tree-sitter
Source: %name-%version.tar

BuildRequires: gcc make
%ifnarch %e2k
BuildRequires: rust-cargo
BuildRequires: /proc
%endif

%description
Tree-sitter is a parser generator tool and an incremental parsing library.
It can build a concrete syntax tree for a source file and efficiently update
the syntax tree as the source file is edited.

%package -n lib%name
Summary: Tree-sitter library
Group: Development/Other

%description -n lib%name
Tree-sitter library

%package -n lib%name-devel
Summary: Devel package for tree-sitter library
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files for tree-sitter library

%package -n %name-cli
Summary: Tree-sitter CLI tool
Group: Development/Other

%description -n %name-cli
Tree-sitter CLI tool

%prep
%setup

%ifnarch %e2k
mkdir -p .cargo
cat >> .cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"

[source."git+https://github.com/bytecodealliance/wasmtime?rev=fa6fcd946b8f6d60c2d191a1b14b9399e261a76d"]
git = "https://github.com/bytecodealliance/wasmtime"
rev = "fa6fcd946b8f6d60c2d191a1b14b9399e261a76d"
replace-with = "vendored-sources"

[source.vendored-sources]
directory = "cli/vendor"
EOF
%endif

%build
%make_build

%ifnarch %e2k
cargo build --offline --release
%endif

%install
export PREFIX=%_prefix
export DESTDIR=%buildroot
export INCLUDEDIR=%_includedir
export LIBDIR=%_libdir
export PCLIBDIR=%_pkgconfigdir
make install

%ifnarch %e2k
mkdir -p %buildroot%_bindir
install -m 0755 target/release/%name %buildroot%_bindir
%endif

# install directory for parser symlinks
install -d %{buildroot}%{_libdir}/%name

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name
%exclude %_libdir/*.a

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/%name.pc

%ifnarch %e2k
%files -n %name-cli
%_bindir/%name
%endif

%changelog
