Name: tre
Version: 0.9.0
Release: alt1

Summary: TRE is "approximate regexp" library
License: BSD
Group: Development/C

Url: https://laurikari.net/tre
Vcs: https://github.com/laurikari/tre.git
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

%define agrep agrep-%name
%define soversion 5

# Automatically added by buildreq on Mon May 10 2004
BuildRequires: hostinfo libdb4-devel python3-devel
BuildRequires: python3(setuptools)

%description
(void package)

%package -n %agrep
Summary: agrep version using TRE library
Group: Text tools
Conflicts: agrep

%description -n %agrep
agrep is a grep-like utility which can do approximate searches.

%package -n lib%name%soversion
Summary: TRE is a regexp matching library with approximate matching capability
Group: System/Libraries

%description -n lib%name%soversion
TRE is a lightweight, robust, and efficient POSIX compliant
regexp matching library with some exciting features such as
approximate matching.

%package -n lib%name-devel
Summary: Development environment for lib%name
Group: Development/C
Requires: lib%name%soversion = %version-%release

%description -n lib%name-devel
TRE is a lightweight, robust, and efficient POSIX compliant
regexp matching library with some exciting features such as
approximate matching.

This is the development environment to compile TRE software.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for lib%name%soversion
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
TRE is a lightweight, robust, and efficient POSIX compliant
regexp matching library with some exciting features such as
approximate matching.

This package contains static library to build statically linked
TRE software.
%endif

%package -n python3-module-%name
Summary: Python bindings for TRE, regex library with approximate matching
Group: Development/Python

%description -n python3-module-%name
TRE is a lightweight, robust, and efficient POSIX compliant
regexp matching library with some exciting features such as
approximate matching.

This package contains Python bindings for TRE.

%prep
%setup

%build
./utils/autogen.sh
%configure %{subst_enable static}
%make_build
cd python
python3 setup.py build

%install
%makeinstall
%find_lang %name
cd python
python3 setup.py install --root=%buildroot

%check
%make check

%files -n %agrep -f %name.lang
%_bindir/agrep
%_man1dir/agrep.1.*

%files -n lib%name%soversion
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/%name.pc
%_includedir/%name/*.h

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%files -n python3-module-%name
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/%name.*.so

%changelog
