%define _unpackaged_files_terminate_build 1

%define _optlevel s
%def_enable qt

%define rname Transmission
%define dname transmission-daemon

Name: transmission
Version: 4.0.6
Release: alt5

Group: Networking/File transfer
Summary: Llightweight BitTorrent client
License: MIT and GPL-2.0-only
Url: http://www.transmissionbt.com/

Provides: %rname = %EVR

Obsoletes: %name-benc2php
Obsoletes: %name-proxy

Requires: %name-gui = %EVR
Requires: %name-cli = %EVR
Requires: %name-remote = %EVR
Requires: %name-daemon = %EVR

Requires(post,postun): desktop-file-utils

Source: http://download.m0k.org/%name/files/%name-%version.tar
Patch2: %name-alt-extra-doc-disable.patch
Patch3: %name-alt-fix-trsnslations-qt.patch
Patch4: %name-miniupnp228.patch
Patch5: %name-alt-fix-FTBFS-cmake4.0.patch
Source1: %dname.init
Source2: %dname.logrotate
Source3: %dname.service
Source4: %name-%version-third-party-dht.tar
Source5: %name-%version-third-party-fast_float.tar
Source6: %name-%version-third-party-fmt.tar
Source7: %name-%version-third-party-googletest.tar
Source8: %name-%version-third-party-libutp.tar
Source9: %name-%version-third-party-utfcpp.tar
Source10: %name-%version-third-party-utfcpp-extern-ftest.tar
Source11: %name-%version-third-party-wide-integer.tar

BuildPreReq: desktop-file-utils

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires: ctest
BuildRequires: gcc-c++ glibc-devel libcurl-devel libevent-devel libnotify-devel libcanberra-devel libdbus-glib-devel libgtk4-devel libgtkmm4-devel libglibmm2.68-devel libpcre2-devel libffi-devel  glib2-devel libsystemd-devel
BuildRequires(pre): rpm-utils desktop-file-utils libalternatives-devel rpm-build-ubt openssl-devel
BuildRequires: libb64-devel
BuildRequires: libnatpmp-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libutfcpp-devel
BuildRequires: libdeflate-devel
BuildRequires: libpsl-devel
%if "%(rpmvercmp '%{get_version glibc-core}' '2.9')" >= "0"
BuildRequires: libgio-devel
%endif
%if_enabled qt
BuildRequires: qt5-base-devel qt5-tools-devel qt5-svg-devel
%endif

%description
Transmission has been built from the ground up to be a lightweight,
yet powerful BitTorrent client. Its simple, intuitive interface
strikes a balance between providing useful functionality without
feature bloat. Furthermore, it is free for anyone to use or modify.

%package common
Group: Networking/File transfer
Summary: Common files for %name
Conflicts: %name < 1.00-alt10
Obsoletes: %name-gui-common < %EVR
%description common
Common files for %name

%package gtk
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %EVR
Requires: %name-common = %EVR
%description gtk
GTK-based graphical BitTorrent client

%if_enabled qt
%package qt
Group: Networking/File transfer
Summary: Graphical BitTorrent client
Provides: %name-gui = %EVR
Requires: %name-common = %EVR
%description qt
Qt-based graphical BitTorrent client
%endif

%package cli
Group: Networking/File transfer
Summary: Command line BitTorrent client
Requires: %name-common = %EVR
%description cli
Command line BitTorrent client

%package remote
Group: Networking/Remote access
Summary: Command line remote interface to %name-daemon
Requires: %name-common = %EVR
%description remote
Command line remote interface to %name-daemon

%package daemon
Group: Networking/File transfer
Summary: Daemonised BitTorrent client
Requires: %name-common = %EVR
%description daemon
Daemonised BitTorrent client

%prep
%setup -a4 -a5 -a6 -a7 -a8 -a9 -a10 -a11
%autopatch -p1
%ifarch %e2k
# error: incomplete type is not allowed
sed -i 's/default_specs\[\] = {/default_specs[5] = {/' \
	third-party/fmt/include/fmt/chrono.h
# undefined reference to ~fixed_static_array()
sed -i '/~fixed_static_array() = default/d' \
	third-party/wide-integer/math/wide_integer/uintwide_t.h
%endif

%build
%cmake \
	-DENABLE_GTK=ON \
%if_enabled qt
	-DENABLE_QT=ON \
%endif
	-DENABLE_CLI=ON \
	-DUSE_SYSTEM_EVENT2=ON \
	-DUSE_SYSTEM_MINIUPNPC=ON \
	-DUSE_SYSTEM_NATPMP=ON \
	-DUSE_SYSTEM_B64=ON \
	-DUSE_SYSTEM_PSL=ON \
	-DUSE_SYSTEM_DEFLATE=ON \
	-DCMAKE_BUILD_TYPE=RelWithDebInfo \
	%nil

%cmake_build

%install
%cmake_install

# made alternatives entries
mkdir -p %buildroot/%_altdir

cat >%buildroot%_altdir/%name-gtk <<__EOF__
%_bindir/%name %_bindir/%name-gtk 30
__EOF__

%if_enabled qt
cat >%buildroot%_altdir/%name-qt <<__EOF__
%_bindir/%name %_bindir/%name-qt 20
__EOF__
%endif

%find_lang %name-gtk

# install daemonic stuff

install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/%dname
install -pD -m755 %SOURCE1 %buildroot%_initdir/%dname
install -pD -m644 %SOURCE3 %buildroot%systemd_unitdir/transmission-daemon.service

%_cmake__builddir/daemon/transmission-daemon -d 2> %_cmake__builddir/daemon/settings.json
sed -i 's,/usr/src/,/var/lib/transmission-daemon/,' %_cmake__builddir/daemon/settings.json
install -pD -m640 %_cmake__builddir/daemon/settings.json %buildroot%_sysconfdir/transmission-daemon/settings.json

mkdir -p %buildroot%_sysconfdir/sysconfig/
echo "TRANSMISSION_OPTIONS=\"-e %_logdir/%dname/%dname.log -g %_localstatedir/%dname\"" > %buildroot%_sysconfdir/sysconfig/%dname

mkdir -p %buildroot%_logdir/%dname
mkdir -p %buildroot%_localstatedir/%dname

# Re-enable if DhtTest.usesBootstrapFile and LT.WebUtilsTest.url passes
# %check
# pushd %_cmake__builddir
# ctest
# popd

%pre daemon
/usr/sbin/groupadd -r -f _%dname
/usr/sbin/useradd -r -g _%dname -d %_localstatedir/%dname -s /dev/null -c 'The Transmission Torrent Client' _%dname >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
        /usr/sbin/usermod -d %_localstatedir/%dname _%dname
fi

%files

%files common
%dir %_datadir/%name
%_iconsdir/hicolor/*/*/*
%_datadir/%name/public_html/

%files gtk -f %name-gtk.lang
%doc AUTHORS COPYING README.md
%_bindir/%name-gtk
%_altdir/%name-gtk
%_man1dir/%name-gtk.1*
%_datadir/applications/%name-gtk.desktop
%_datadir/metainfo/transmission-gtk.metainfo.xml

%if_enabled qt
%files qt
%doc AUTHORS COPYING README.md
%_bindir/%name-qt
%_altdir/%name-qt
%_datadir/applications/%name-qt.desktop
%_datadir/%name/translations/%{name}_*.qm
%_man1dir/%name-qt.1*
%endif

%files cli
%doc AUTHORS COPYING README.md
%_bindir/%name-create
%_man1dir/%name-create.*
%_bindir/%name-edit
%_man1dir/%name-edit.*
%_bindir/%name-show
%_man1dir/%name-show.*
%_bindir/transmission-cli
%_man1dir/transmission-cli.*

%files remote
%doc AUTHORS COPYING README.md
%_bindir/%name-remote
%_man1dir/%name-remote.*

%files daemon
%doc AUTHORS COPYING README.md
%_bindir/%name-daemon
%_man1dir/%name-daemon.*
%systemd_unitdir/transmission-daemon.service
%config(noreplace) %_sysconfdir/logrotate.d/%dname
%config(noreplace) %_sysconfdir/sysconfig/%dname
%config %_initdir/%dname
%attr(0750,root,_%dname) %dir %_sysconfdir/%dname
%config(noreplace) %_sysconfdir/%dname/settings.json
%attr(0750,_%dname,_%dname) %dir %_localstatedir/%dname
%attr(1770,root,_%dname) %dir %_logdir/%dname

%changelog
