# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: toybox
Version: 0.8.13
Release: alt1
Summary: All-in-one Linux command line
License: 0BSD
Group: Shells
Url: http://landley.net/toybox/
Vcs: https://github.com/landley/toybox

Source: %name-%version.tar
BuildRequires: glibc-devel-static
BuildRequires: liblzma-devel-static
BuildRequires: libssl-devel-static
BuildRequires: musl-devel-static >= 1.2.5-alt7
BuildRequires: zlib-devel-static
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc
}}

%description
%summary.

Statically compiled with musl and not requiring symlinks for toys
(shell command recursion).

%prep
%setup

%build
cp .gear/config .config
%make silentoldconfig
diff -u .gear/config .config ||:
%make_build CC=musl-gcc CFLAGS="-I/etc/sysconfig/kernel/include %optflags" LDFLAGS="-static-pie" NOSTRIP=1 V=1

%install
install -Dp toybox -t %buildroot%_bindir

%check
# armh: scripts/test.sh: line 38: 2887805 Bus error
%ifnarch armh
# Known failures:
rm tests/du.test	# 0 on tmpfs
rm tests/id.test	# Additional groups
rm tests/sed.test	# FAIL: sed s after NUL
rm tests/tar.test	# FAIL: tar xform trailing slash special case
rm tests/timeout.test	# FAIL: timeout -i
rm tests/taskset.test	# Fails due to cpuset
%ifarch %ix86
rm tests/devmem.test	# FAIL: devmem read 8
%endif
%make_build tests
%endif

# List compiled in commands.
./toybox
# Check it's statically linked.
ldd toybox | grep 'statically linked'
readelf -d toybox | grep 'FLAGS.* PIE'
file toybox | grep 'pie executable.* static-pie linked'
# Test 'shell command recursion'.
./toybox bash <<-EOF | grep -Fx 'toybox %version'
	ls --version
EOF

ls -l toybox
size toybox

%files
%define _customdocdir %_docdir/%name
%doc LICENSE README .config
%_bindir/toybox

%changelog
