%define _unpackaged_files_terminate_build 1
%ifarch x86_64
%define cpro_arch amd64
%define miss_arch ia32
%else
%define cpro_arch ia32
%define miss_arch amd64
%endif

Name:    token-manager
Version: 5.2.3
Release: alt1

Summary: Certificate manager for CryptoPro CSP
License: MIT
Group:   Security/Networking
URL:     https://github.com/wolandius/token-manager

ExclusiveArch: x86_64 %ix86

Source: %name-%version.tar
Source1: cpconfig-pam.alt
Patch0: token-manager-alt-links.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libpam-devel

Requires: polkit opensc

%description
A GTK front-end for Crypto Pro CSP.

The application requires following packages to be installed before you use
it (for x86_64 architecture):

* opensc
* cprocsp-rdr-pcsc-64
* lsb-cprocsp-capilite-64
* opensc, cprocsp-rdr-gui
* cprocsp-rdr-gui-gtk

Parent project by Boris Makarenko https://github.com/bmakarenko/token-manager

%prep
%setup
%patch0 -p1

%build
%python3_build

%install
%python3_install
%ifarch x86_64
mv %buildroot/usr/{lib,%_lib}
%endif
install -Dm 0644 %SOURCE1 %buildroot%_sysconfdir/pam.d/cpconfig-%cpro_arch
%ifarch %ix86
rm %buildroot%_desktopdir/token-manager.desktop
%else
rm %buildroot%_desktopdir/token-manager-%miss_arch.desktop
%endif
rm %buildroot%_sysconfdir/pam.d/cpconfig-%miss_arch \
   %buildroot%_sysconfdir/security/console.apps/cpconfig-%miss_arch
%find_lang token_manager

%files -f token_manager.lang
%_bindir/%name
%_desktopdir/*.desktop
%config(noreplace) %_sysconfdir/pam.d/cpconfig-%cpro_arch
%config(noreplace) %_sysconfdir/security/console.apps/cpconfig-%cpro_arch
%python3_sitelibdir/token_manager*
%_iconsdir/hicolor/*x*/apps/%name.png
%_datadir/token_manager
%_datadir/polkit-1/actions/*.policy

%changelog
