# Spec file for TinyCA2 utility

%def_without ru_locale

Name: tinyca2
Version: 0.7.6
Release: alt1.git1f402a5

Summary: graphical tool for managing a Certification Authority
Summary(ru_RU.UTF-8): графическая утилита для управления Certification Authority

License: GPL
Group: Security/Networking
URL: https://github.com/thooge/tinyca
#URL: https://www.hoogi.de/tinyca/
#URL: https://github.com/simonswine/tinyca2_debian
#URL: http://tinyca.sm-zone.net/

Packager: Nikolay A. Fetisov <naf@altlinux.ru>
BuildArch: noarch

Source0: %name-%version.tar
Patch0:  %name-%version-%release.patch

#Source1: %%name.png
Source2: %name.po

Source3: %name-16.png
Source4: %name-32.png
Source5: %name-48.png

Patch1: %name-0.7.0-alt-ru_po.patch
Patch2: %name-0.7.2-alt-Gtk2_init.patch
Patch3: %name-0.72-alt-desktop_l10n.patch
Patch4: %name-0.7.5_7-alt-pathes.patch

BuildRequires: perl-devel, perl-Glib, perl-Gtk2, perl-Locale-gettext
BuildRequires: perl-Config-Tiny
Requires: openssl

%description
TinyCA2 is a graphical tool written in Perl/Gtk2 to manage a small
Certification Authority (CA) using openssl.

TinyCA2 supports
- creation and revocation of x509 - S/MIME certificates.
- PKCS#10 requests.
- exporting certificates as PEM, DER, TXT, and PKCS#12.
- server certificates for use in web servers, email servers, IPsec,
  and more.
- client certificates for use in web browsers, email clients, IPsec,
  and more.
- creation and management of SubCAs


%description -l ru_RU.UTF-8
TinyCA2  -  написанная на Perl/GTK2 графическая утилита для 
управления Certification Authority (CA) небольших размеров, 
с использованием openssl.

TinyCA2 поддерживает:
- создание и отзыв сертификатов x509 и S/MIME
- запросы PKCS#10
- экспорт сертификатов в форматах PEM, DER, TXT и PKCS#12
- управление серверными сертификатами для использования с серверами 
  web, email, с IPsec, и т.д.
- управление клиентскими сертификатами для использования в браузерах,
  почтовых клиентах, для IPsec и пр.
- создание и управление SubCA


%define libdir		%_datadir/tinyca
%define templatesdir	%_sysconfdir/tinyca
%define localedir	%_datadir/locale

# Defining _perl_lib_path for correct work of AutoReqProv
%global _perl_lib_path %libdir

%prep
%setup
%patch0 -p1

%if_with ru_locale
%patch1
/bin/install -m 0644 -- %SOURCE2 po/ru.po
/bin/mkdir -p -- locale/ru/LC_MESSAGES
%endif

%patch2
%patch3
%patch4


%build
# Configure sources
./install.sh
/usr/bin/make -C po

%install
LANGUAGES="de es cs fr sv %{?_with_ru_locale:ru}"

/bin/mkdir -p -- %buildroot%_bindir
/bin/mkdir -p -- %buildroot%libdir
/bin/mkdir -p -- %buildroot%libdir/GUI
/bin/mkdir -p -- %buildroot%libdir/icons
/bin/mkdir -p -- %buildroot%templatesdir

/bin/install -m 0644 -- lib/*.pm %buildroot%libdir/
/bin/install -m 0644 -- lib/GUI/*.pm %buildroot%libdir/GUI/
/bin/install -m 0644 -- icons/* %buildroot%libdir/icons/
/bin/install -m 0644 -- templates/openssl.cnf %buildroot%templatesdir/
/bin/install -m 0644 -- templates/tinyca.cnf %buildroot%templatesdir/
/bin/install -m 0755 -- %name %buildroot%_bindir/

for LANG in $LANGUAGES; do
   /bin/mkdir -p -- %buildroot%localedir/$LANG/LC_MESSAGES/
   /bin/install -D -m 0644 -- locale/$LANG/LC_MESSAGES/%name.mo %buildroot%localedir/$LANG/LC_MESSAGES/%name.mo
done

/bin/mkdir -p -- %buildroot%_desktopdir
/bin/install -m 0644 -- %name.desktop %buildroot%_desktopdir

/bin/mkdir -p -- %buildroot%_miconsdir %buildroot%_liconsdir %buildroot%_niconsdir
/bin/install -m 0644 -- %SOURCE3 %buildroot%_miconsdir/%name.png
/bin/install -m 0644 -- %SOURCE4 %buildroot%_niconsdir/%name.png
/bin/install -m 0644 -- %SOURCE5 %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%doc CHANGES INSTALL

%_bindir/%name
%{libdir}*
%dir %templatesdir
%config %templatesdir/openssl.cnf
%config %templatesdir/tinyca.cnf
%_desktopdir/%name.desktop
%_miconsdir/%{name}*
%_niconsdir/%{name}*
%_liconsdir/%{name}*

%changelog
