Name: tin
Version: 2.6.4
Release: alt2

Summary: A basic Internet news reader
License: BSD
Group: Networking/News

URL: http://www.tin.org/
Source0: ftp://ftp.tin.org/pub/news/clients/tin/stable/%name-%version.tar.xz
Source1: tin.watch
Source2: tin.attributes

Patch: tin-2.6.4-enable_coloring.patch

# Automatically added by buildreq on Wed Dec 28 2011
# Manually removed from buildreq'ed string:
# - specific MTA package (such as postfix): replace it by requirement of /usr/sbin/sendmail
BuildRequires: gnupg libgsasl-devel libncursesw-devel libpcre2-devel libuu-devel
BuildRequires: libcanlock-devel libicu-devel libidn2-devel liburiparser-devel
BuildRequires: zlib-devel libgnutls-devel
BuildRequires: xorg-proto-devel
BuildRequires: /usr/sbin/sendmail
# utils
BuildRequires: perl(Net/NNTP.pm)
BuildRequires: perl(Term/ReadLine.pm)
BuildRequires: perl(Pod/Usage.pm)

# Global symbol "$mod" requires explicit package name (did you forget to declare "my $mod"?) at /usr/src/tmp/tin-buildroot/usr/bin/opt-case.pl line 27.
%add_findreq_skiplist %_bindir/opt-case.pl
%add_findreq_skiplist %_bindir/w2r.pl

%description
Tin is a basic, easy to use Internet news reader. Tin can read news locally or
remotely via an NNTP (Network News Transport Protocol) server.

%package utils
Summary: Perl utilities for tin
Group: Networking/News
BuildArch: noarch

%description utils
This package contains extra perl scripts for tin provided by upstream.

%prep
%setup
%patch -p1

%build
%configure \
	--with-spooldir=/var/lib/news \
	--with-nntps=gnutls \
	--with-screen=ncursesw \
	--with-pcre2-config=%_bindir/pcre2-config \
	--with-mailer=/usr/sbin/sendmail \
	--with-nntp-default-server="news" \
	--with-mime-default-charset="KOI8-R" \
	--disable-mime-strict-charset \
	--enable-color \
	--enable-nntp \
	--enable-prototypes \
	--enable-locale \
	--enable-mh-mail-handling \
	--enable-echo \
	--enable-nntp-only \
	--enable-cancel-locks

subst 's/(INSTALL) -s/(INSTALL)/g' src/Makefile

%make_build build

%install
%makeinstall_std
install -pD -m644 doc/tin.defaults %buildroot%_sysconfdir/tin/tinrc
install -pD -m644 %_sourcedir/tin.attributes %buildroot%_sysconfdir/tin/attributes

%find_lang %name

%files -f %name.lang
%dir %_sysconfdir/tin
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/tin/tinrc
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/tin/attributes
%_bindir/tin
%_bindir/rtin
%_bindir/metamutt
%_man1dir/*
%_man5dir/*
%doc README doc/{CHANGES,CREDITS,TODO,DEBUG_REFS,filtering,good-netkeeping-seal,*.txt}
# conflicts with mutt1.5 package:
%exclude %_man5dir/mbox.*
%exclude %_man5dir/mmdf.*

%files utils
%_bindir/*.pl

%changelog
