%def_disable snapshot

Name: timg
Version: 1.6.3
Release: alt1

Summary: terminal image viewer
License: GPL-2.0
Group: Graphics
Url: https://timg.sh

Vcs: https://github.com/hzeller/timg.git

%if_disabled snapshot
Source: https://github.com/hzeller/timg/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ ninja-build
BuildRequires: pkgconfig(libdeflate)
BuildRequires: pkgconfig(libsixel)
BuildRequires: pkgconfig(libturbojpeg)
BuildRequires: pkgconfig(libexif)
BuildRequires: pkgconfig(libavutil)
BuildRequires: pkgconfig(libswscale)
BuildRequires: pkgconfig(libswresample)
BuildRequires: pkgconfig(libavcodec)
BuildRequires: pkgconfig(libavdevice)
BuildRequires: pkgconfig(libavfilter)
BuildRequires: pkgconfig(GraphicsMagick++)
BuildRequires: pkgconfig(poppler-glib)
BuildRequires: pkgconfig(librsvg-2.0)

%description
A user-friendly terminal image viewer that uses graphic capabilities of
terminals (Sixel, Kitty or iterm2), or 24-Bit color capabilities and unicode
character blocks if these are not available.

%prep
%setup -n %name-%version

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake \
    -GNinja \
    -DTIMG_VERSION_FROM_GIT=OFF
%nil
%cmake_build

%install
%cmake_install
%find_lang --all-name --output=%name.lang %name

%files -f %name.lang
%_bindir/%name
%_man1dir/%name.1*
%doc README*

%changelog
