%define _unpackaged_files_terminate_build 1
%define IF_ver_gteq() %if "%(rpmvercmp '%1' '%2')" >= "0"
%{expand: %(sed 's,^%%,%%global ,' /usr/lib/rpm/macros.d/ubt)}
%define ubt_id %__ubt_branch_id

%IF_ver_gteq %ubt_id M110
%def_disable use_xvt
%else
%def_enable use_xvt
%endif

Name: timeshift
Version: 25.07.7
Summary: System restore tool for Linux
Release: alt1
License: GPL-2.0-or-later
Group: Archiving/Backup
URL: https://github.com/linuxmint/timeshift

Source: %name-%version.tar
Source1: firsttime-snapshot.sh
Patch1: alt-use-xvt.patch
Patch2: alt-fix-41711.patch
Patch3: alt-fix-41055.patch
Patch4: alt-fix-47796.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-macros-meson
BuildRequires: cmake
BuildRequires: meson
BuildRequires: vala
BuildRequires: libgee0.8-devel
BuildRequires: libjson-glib-devel
BuildRequires: libvte3-devel
BuildRequires: libxapps-devel
BuildRequires: help2man
Requires: rsync

%description
System restore tool for Linux. Creates filesystem snapshots using
rsync+hardlinks, or BTRFS snapshots. Supports scheduled snapshots, multiple back
up levels, and exclude filters. Snapshots can be restored while system is
running or from Live CD/USB.

%prep
%setup
%if_enabled use_xvt
%patch1 -p1
%endif
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
%meson
%meson_build

%install
%meson_install
#firsttime script, start with zz, as it should be executed as late as possible
install -m755 -pD %SOURCE1 %buildroot%_sysconfdir/firsttime.d/zz-firsttime-snapshot.sh
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_bindir/%name-gtk
%_bindir/%name-launcher
%_datadir/%name
%_sysconfdir/%name
%_desktopdir/%name-gtk.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_datadir/metainfo/com.linuxmint.timeshift.metainfo.xml
%_pixmapsdir/%name.png
%_datadir/polkit-1/actions/in.teejeetech.pkexec.timeshift.policy
%_sysconfdir/firsttime.d/zz-firsttime-snapshot.sh
%_man1dir/%name-gtk.1.*
%_man1dir/%name.1.*
%doc README.md LICENSES/GPL-2.0-or-later.txt

%changelog
