Name: timeline
Version: 2.11.0
Release: alt1
Group: Office
Summary: Displaying and navigating events on a timeline
License: GPL-3.0 and CC-BY-SA-3.0
Url: http://thetimelineproj.sourceforge.net/

Source: %name-%version.zip
Source1: %name.1
Source2: ru.po
Source3: %name.watch
Patch: timeline-fix-paths.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: gettext
BuildRequires: python3-devel
BuildRequires: unzip

%description
Timeline is a cross-platform application for displaying and navigating
events on a timeline.

Features:
- Organize events in hierarchical categories
- Move and resize events with the mouse
- Duplicate events
- Search events
- Go to a specific date
- Scroll and zoom with mouse wheel
- Different representation depending on zoom level
- Export to image
- Available in multiple languages

%package -n python3-module-timelinelib
Group: Development/Python3
Summary: Python module for %name, %summary

%description -n python3-module-timelinelib
Python module for %name, %summary

%prep
%setup
%patch -p0
cp %SOURCE2 translations/ru.po
rm -f timeline/translations/*/LC_MESSAGES/timeline.mo

cat > %name.desktop <<@@@
[Desktop Entry]
Icon=%name
Name=Timeline
Comment=Display and navigate information on a timeline
Comment[ru]=Редактор данных на временной шкале
Exec=%name
Terminal=false
Type=Application
Categories=Office;Calendar;
StartupNotify=false
@@@

%build
python3 ./tools/generate-mo-files.py

%install
install -Dpm0755 source/timeline.py %buildroot%_bindir/timeline

mkdir -p %buildroot%_datadir/timeline
cp -pr icons %buildroot%_datadir/timeline/
 
mkdir -p %buildroot%python3_sitelibdir/timelinelib
cp -pr source/timelinelib/* %buildroot%python3_sitelibdir/timelinelib/
 
install -Dpm0644 icons/48.png %buildroot%_datadir/icons/hicolor/48x48/apps/timeline.png
 
install -Dm0644 %name.desktop %buildroot%_desktopdir/%name.desktop
 
mkdir -p %buildroot%_datadir/locale
cp -a translations/*/ %buildroot%_datadir/locale/
 
install -Dm0644 %SOURCE1 %buildroot%_man1dir/%name.1

# Drop bundled python dependencies.
rm -rf %buildroot%_datadir/timeline/dependencies

%find_lang %name

%files -f %name.lang
%doc AUTHORS README
%_bindir/*
%_datadir/%name
%_iconsdir/hicolor/*/apps/*
%_desktopdir/%name.desktop
%_man1dir/*

%files -n python3-module-timelinelib
%python3_sitelibdir/timelinelib*

%changelog
