%define base thunar-volman
Name: %base-plugin
Version: 4.20.0
Release: alt1

Summary: Thunar volume manager plugin
Summary (ru): Дополнение Thunar для управления подключенными устройствами
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/thunar/thunar-volman
Packager: XFCE Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/thunar-volman.git
Source: %base-%version.tar
Patch: %base-%version-%release.patch

BuildRequires(pre): rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfconf-devel libexo-gtk3-devel libxfce4ui-gtk3-devel libxfce4util-devel
BuildRequires: libgtk+3-devel libgudev-devel libnotify-devel

Requires: gvfs

%define _unpackaged_files_terminate_build 1

%description
thunar-volman is an extension for the Thunar File Manager, which enables
automatic management of removable drives and media. For example, if
thunar-volman is installed and configured properly, and you plug in your
digitcal camera, it will automatically spawn your preferred photo
application and import the new pictures from your camera.

%description -l ru
Данный пакет содержит в себе дополнение для файлового менеджера Thunar
позволяющее управлять подключенными к системе съемными устройствами.
Например, если данное дополнение установлено и настроено и вы подключите
цифровую камеру, автоматически запустится указанное вами приложение для
получения фотографий с камеры и работы с ними.

%prep
%setup -n %base-%version
%patch -p1

%build
%xfce4reconf
%configure \
    --enable-notifications \
    --enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang %base

%files -f %base.lang
%doc README.md AUTHORS NEWS
%_bindir/*
%_iconsdir/hicolor/*/*/*
%_desktopdir/*.desktop

%changelog
