Name: tftp
Version: 5.2
Release: alt4

Summary: The client for the Trivial File Transfer Protocol (TFTP)
License: BSD
Group: Networking/File transfer
Url: https://git.kernel.org/pub/scm/network/tftp/tftp-hpa.git/

Source0: %name-%version.tar

%define sys_user %name
%define sys_group %name
%define bootdir %_localstatedir/tftpboot

BuildRequires: libreadline-devel

%description
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the user interface
for TFTP, which allows users to transfer files to and from a remote
machine. This program, and TFTP, provide very little security, and
should not be enabled unless it is expressly needed.


%package -n tftpd
Summary: The server for the Trivial File Transfer Protocol (TFTP)
Group: System/Servers
Provides: %name-server-common = %version-%release
Conflicts: %name-server < 5.0-alt1

%description -n tftpd
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.


%package server-standalone
Summary: The server for the Trivial File Transfer Protocol (TFTP) - standalone mode
Group: System/Servers
BuildArch: noarch
Requires: tftpd >= 0.49-alt1
Conflicts: %name-server = 0.49-alt1

%description server-standalone
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.
This package provides script for run TFTP server in standalone mode
with /sbin/service, disabled by default on a ALT Linux systems.


%package server-xinetd
Summary: The server for the Trivial File Transfer Protocol (TFTP) - xinetd mode
Group: System/Servers
Provides: %name-server = %version-%release
Obsoletes: %name-server < %version-%release
BuildArch: noarch
Requires: %{name}d
Conflicts: %name-server < 5.0-alt1

%description server-xinetd
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations. This package provides the server for
TFTP, which allows users to transfer files to and from a remote
machine. TFTP provides very little security, and should not be enabled
unless it is expressly needed.
This package provides script for run TFTP server via xinetd, disabled
by default on a ALT Linux systems.


%package doc
Summary: Documentation for TFTP server and client
Group: Documentation
BuildArch: noarch

%description doc
The Trivial File Transfer Protocol (TFTP) is normally used only for
booting diskless workstations.
This package provides documentation for TFTP client and server.


%prep
%setup

%build
%define _optlevel s
%add_optflags -fcommon
%autoreconf
%configure \
    --enable-largefile \
    --with-readline \
    --with-remap \
    --with-ipv6

%make_build

for f in tftp.xinetd tftpd.sysconfig tftpd.init tftp.service; do
    sed 's|@USER@|%sys_user|g;s|@BOOTDIR@|%bootdir|g' $f.in > $f
done

bzip2 --best --keep --force CHANGES


%install
%make_install INSTALLROOT=%buildroot install
ln -sf {in.,%buildroot%_sbindir/}tftpd
install -D -m 0640 tftp.xinetd %buildroot%_sysconfdir/xinetd.d/tftp
install -D -m 0644 tftpd.sysconfig %buildroot%_sysconfdir/sysconfig/tftpd
install -D -m 0755 tftpd.init %buildroot%_initdir/tftpd
install -D -m 0644 tftp.service %buildroot%_unitdir/tftp.service
install    -m 0644 tftp.socket %buildroot%_unitdir/tftp.socket
install -d -m 0755 %buildroot{%bootdir,%_docdir/%name-%version}
install -m 0644 CHANGES.* README* %buildroot%_docdir/%name-%version/


%post -n tftpd
%_sbindir/groupadd -rf %sys_group ||:
%_sbindir/useradd -r -g %sys_group -d /dev/null -s /dev/null -n %sys_user &>/dev/null ||:

%post server-standalone
%post_service tftpd ||:

%preun server-standalone
%preun_service tftpd ||:


%files
%_bindir/*
%_man1dir/*


%files -n tftpd
%_unitdir/*
%_sbindir/*
%_man8dir/*
%dir %bootdir


%files server-standalone
%config(noreplace) %_sysconfdir/sysconfig/*
%_initdir/*


%files server-xinetd
%config(noreplace) %_sysconfdir/xinetd.d/*


%files doc
%_docdir/%name-%version


%changelog
