Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ libX11-devel pkgconfig(lcms2) pkgconfig(libopenjp2) pkgconfig(libtiff-4) qt5-phonon-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname texstudio
Name:           texstudio
Version:        4.8.9
Release:        alt1

Summary:        A feature-rich editor for LaTeX documents
# texstudio binary: GPLv3 due to static linkage of bundled qcodeedit
# texstudio data and image files: GPLv2+
License:        GPLv2+ and GPLv3
URL:            https://www.texstudio.org

Source0:        https://github.com/texstudio-org/texstudio#/archive/%{name}-%{version}.tar.gz
Source1:        texstudio.desktop
Patch1:         texstudio-use-system-qtsingleapplication-instead-of-bundled-on.patch
Patch2:         texstudio-disable-update-check.patch
# don't muck with default build flags
Patch3:         texstudio-wtf_flags.patch
BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake
BuildRequires:  qt5-base-devel
BuildRequires:  qt5-tools qt5-tools-devel qt5-script-devel
#BuildRequires:  qt5-tools-devel qt5-tools-devel-static
BuildRequires:  qt5-svg-devel
BuildRequires:  qt5-script-devel 
BuildRequires:  hunspell-utils libhunspell-devel
BuildRequires:  desktop-file-utils
BuildRequires:  gettext gettext-tools
BuildRequires:  libpoppler-qt5-devel
BuildRequires:  libqtsingleapplication-qt5-devel
BuildRequires:  libqtermwidget-devel qt5-multimedia-devel
BuildRequires:  quazip-qt5-devel
BuildRequires:  zlib-devel libpoppler-cpp-devel qt5-declarative-devel qt5-assistant

Requires:       tex(latex)
Requires:       tex(preview.sty)
Requires:       texlive
Requires:       libqt5-svg libqt5-qml
Requires:       libqtermwidget
Provides:       bundled(qcodeedit) 
Provides:       texmakerx = %{version}-%{release}
Obsoletes:      texmakerx < 2.2-1
Source44: import.info
%description
TeXstudio gives you an environment where you can 
easily create and manage LaTeX documents.
It provides modern writing support, like interactive spell checking, 
code folding, syntax highlighting, integrated pdf viewer
and various assistants. 
Also it serves as a starting point from where you can easily run 
all necessary LaTeX tools.

%prep
%setup -q -n %{name}-%{version}
#patch1 -p1 -b .qtsingle
%patch2 -p1 -b .update_check
#patch3 -p1 -b .wtf_flags

rm -rf {hunspell,qtsingleapplication,quazip}

%build

%cmake \
%ifnarch %{ix86} x86_64 %{arm}
    -DTEXSTUDIO_ENABLE_CRASH_HANDLER=OFF \
%endif

%cmake_build

%install
%cmake_install

#install
#make install INSTALL_ROOT=$RPM_BUILD_ROOT -C %{_target_platform}

install -Dp -m 0644 utilities/texstudio16x16.png \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/16x16/apps/texstudio.png
install -Dp -m 0644 utilities/texstudio22x22.png \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/22x22/apps/texstudio.png
install -Dp -m 0644 utilities/texstudio32x32.png \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/32x32/apps/texstudio.png
install -Dp -m 0644 utilities/texstudio48x48.png \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps/texstudio.png
install -Dp -m 0644 utilities/texstudio64x64.png \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/46x46/apps/texstudio.png


rm -rf $RPM_BUILD_ROOT%{_datadir}/%{name}/{AUTHORS,COPYING,*.desktop,tex*.png,CHANGELOG.txt}
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{name}/{*.dic,*.aff}
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{name}/qt_*.qm

%find_lang %{name} --with-qt

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications/
desktop-file-install --dir %{buildroot}%{_datadir}/applications %{SOURCE1}

%files -f %{name}.lang
%{_bindir}/texstudio
%dir %{_datadir}/texstudio/
%dir %{_datadir}/doc/texstudio/_images/
%dir %{_datadir}/doc/texstudio/_sphinx_design_static/
%dir %{_datadir}/doc/texstudio/_static/
%{_datadir}/doc/texstudio/_sphinx_design_static/*
%{_datadir}/doc/texstudio/_static/*
%{_datadir}/doc/texstudio/_images/*
%{_datadir}/texstudio/*.png
%{_datadir}/doc/texstudio/*.css
%{_datadir}/doc/texstudio/*.js
%{_datadir}/doc/texstudio/*.png
#{_datadir}/doc/texstudio/latex2e.*
%{_datadir}/texstudio/*.stopWords
%{_datadir}/texstudio/*.stopWords.level2
%{_datadir}/texstudio/de_DE.badWords
%{_datadir}/texstudio/template_*.tex
%{_datadir}/texstudio/template_*.zip
%{_datadir}/texstudio/*.json
%{_datadir}/texstudio/*.js
%{_datadir}/texstudio/th_*.dat
%{_datadir}/doc/texstudio/*.html
%{_datadir}/doc/texstudio/CHANGELOG.md
%{_datadir}/texstudio/README*.txt
%{_datadir}/applications/texstudio.desktop
%{_datadir}/metainfo/texstudio.metainfo.xml
%{_datadir}/icons/hicolor/*/apps/*.png
%{_datadir}/icons/hicolor/*/apps/*.svg

%doc utilities/AUTHORS utilities/COPYING utilities/manual/CHANGELOG.txt

%changelog
