%define _unpackaged_files_terminate_build 1

Name: 	 tellico
Version: 4.1.4
Release: alt1

Summary: A collection manager for KDE
License: GPL-2.0+
Group:   Graphical desktop/KDE
Url:     http://tellico-project.org/
VCS:	 https://invent.kde.org/office/tellico.git

ExcludeArch: armh ppc64le %ix86

Source: %name-%version.tar

BuildRequires(pre): rpm-build-kf6
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-qt6-webengine
BuildRequires: gcc-c++
BuildRequires: extra-cmake-modules
BuildRequires: qt6-declarative-devel
BuildRequires: kde6-libkcddb-devel
BuildRequires: kde6-libksane-devel
BuildRequires: kf6-karchive-devel
BuildRequires: kf6-kcodecs-devel
BuildRequires: kf6-kcoreaddons-devel
BuildRequires: kf6-kcrash-devel
BuildRequires: kf6-kdoctools-devel
BuildRequires: kf6-kdoctools-devel-static
BuildRequires: kf6-kfilemetadata-devel
BuildRequires: kf6-kguiaddons-devel
BuildRequires: kf6-kiconthemes-devel
BuildRequires: kf6-kio-devel
BuildRequires: kf6-kitemmodels-devel
BuildRequires: kf6-kjobwidgets-devel
BuildRequires: kf6-knewstuff-devel
BuildRequires: kf6-kparts-devel
BuildRequires: kf6-ktextwidgets-devel
BuildRequires: kf6-kwallet-devel
BuildRequires: kf6-kwidgetsaddons-devel
BuildRequires: kf6-kwindowsystem-devel
BuildRequires: kf6-kxmlgui-devel
BuildRequires: kf6-solid-devel
BuildRequires: libdiscid-devel
BuildRequires: libexempi-devel
BuildRequires: libpoppler-qt6-devel
BuildRequires: libtag-devel
BuildRequires: libxml2-devel
BuildRequires: libxslt-devel
BuildRequires: libyaz-devel
BuildRequires: qimageblitz5-devel
%ifarch %qt6_qtwebengine_arches
BuildRequires: qt6-webengine-devel
%endif
BuildRequires: qt6-charts-devel
BuildRequires: libcdio-devel

%ifarch %qt6_qtwebengine_arches
# There is no KHtml for KF6
%define use_khtml FALSE
%else
%define use_khtml FALSE
%endif

%description
Tellico is a KDE application for organizing your collections. It
provides default templates for books, bibliographies, videos, music,
video games, coins, stamps, trading cards, comic books, and wines.

%prep
%setup

%build

%K6init no_altplace
%K6build -DUSE_KHTML:BOOL=%use_khtml

%install
%K6install

# fix python shebangs
find %buildroot -type f -print0 |
      xargs -r0 grep -lZ '^#![[:space:]]*%_bindir/.*python$' -- |
      xargs -r0 sed -E -i '1 s@^(#![[:space:]]*)%_bindir/(env[[:space:]]+)?python$@\1%__python3@'

%find_lang --with-kde %name

%files -f %name.lang
%doc AUTHORS README.md
%_K6bin/*
%_datadir/%name
%_K6xdgapp/*.desktop
%_K6icon/hicolor/*/apps/%name.png
%_K6icon/hicolor/*/mimetypes/application-x-%name.png
%_datadir/kconf_update/*
%_K6cfg/*.kcfg
%_K6xdgconf/%{name}*
%_K6xdgmime/%name.xml
%_datadir/metainfo/org.kde.tellico.appdata.xml
%_datadir/knsrcfiles/tellico-*.knsrc

%changelog
