# various various
%add_tcl_req_skip critcl
# modules/amazon-s3: tcl-xml is in pretty dead state
%add_tcl_req_skip xml
# modules/map: this should be in tklib probably
%add_tcl_req_skip Tk
%add_tcl_req_skip img::png
# pseudo packages, too tricky for reqprov finder
%add_tcl_req_skip page::plugin
%add_tcl_req_skip doctools::idx::export::plugin
%add_tcl_req_skip doctools::idx::import::plugin
%add_tcl_req_skip doctools::toc::export::plugin
%add_tcl_req_skip doctools::toc::import::plugin
%add_tcl_req_skip pt::peg::export::plugin
%add_tcl_req_skip pt::peg::import::plugin
# actually provided by tcl 8.6
%add_tcl_req_skip TclOO
# Windows platform
%add_tcl_req_skip twapi

%def_without bootstrap
%if_with bootstrap
%add_tcl_req_skip Trf
%add_tcl_req_skip zlibtcl
%endif

Name: tcllib
Version: 1.21
Release: alt1.1
Epoch: 1

Summary: The Tcl standard library
License: BSD
Group: Development/Tcl
Url: https://core.tcl.tk/tcllib/
BuildArch: noarch

BuildRequires(pre): rpm-build-tcl >= 0.2.1-alt2
BuildRequires: tcl >= 8.4.0-alt1

# cause segfault in some apps (e.g. tkabber)
Conflicts: tcl-trf < 2.1-alt8

# repacked https://core.tcl-lang.org/tcllib/uv/tcllib-%version.tar.gz
Source: %name-%version.tar
Patch1: 0001-sync-d-with-reality-i-hope.patch
Patch2: 0002-ALT-TEA.patch
Patch3: 0003-ALT-filetypes.tcl-fix-package-requirement.patch

%description
Tcllib is a collection of utility modules for tcl. These modules provide
a wide variety of functionality, from implementation  of standard data
structures  to implementation of common networking protocols.  the intent
is to collect commoly used function into a single library, which users can
rely on to be available and stable.

%prep
%setup
%autopatch -p2

%install
%configure
%make_install DESTDIR=%buildroot install

find examples -type f -print0 |xargs -r0 chmod 0644 --

%check
make check

%files
%doc ChangeLog README* license* devdoc examples support/releases/history support/releases/PACKAGES
%_bindir/dtplite
%_bindir/page
%_bindir/mkdoc
%_bindir/nns*
%_bindir/page
%_bindir/pt
%_bindir/tcldocstrip
%_tcldatadir/%name%version
%_mandir/mann/*

%changelog
