# -*- rpm-spec -*-
# $Id: tcl-readline,v 1.13 2006/07/22 12:12:05 me Exp $

%define teaname readline
%define srcname tclreadline
%define srcver 2.3.8

Name: tcl-%teaname
Version: %srcver
Release: alt1

Summary: GNU readline for the Tcl scripting language
License: BSD
Group: Shells
Url: https://github.com/flightaware/tclreadline

# repacked https://github.com/flightaware/tclreadline/archive/v%version.tar.gz
Source0: %srcname-%srcver.tar
Source1: tcl-readline.watch

Patch1: DEBIAN-functions.patch
Patch2: 0001-ALT-init.patch
Patch3: 0002-ALT-lib64.patch
Patch4: 0003-ALT-DEBIAN-man-page.patch

BuildRequires: libreadline-devel libtinfo-devel rpm-build >= 4.0.4-alt41 tcl-devel >= 8.4.0-alt1 tk-devel
Requires: tcl >= 8.4.0-alt1

%description
%name makes the gnu readline available to the scripting language tcl.
The primary purpose of the package is to facilitate the interactive
script development by the means of word and file name completion
as well as history expansion (well known from shells like bash).

%prep
%setup -q -n %srcname-%srcver
%patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p2

%build
autoreconf -fisv -Iaux
%add_optflags -DUSE_NON_CONST
%configure \
	--disable-static \
	--enable-tclstub \
	--libdir=%_tcllibdir \
	--with-tk=%_libdir \
	--with-tlib-library="-ltinfo" \
	#
%make_build

%install
%make_install DESTDIR=%buildroot install \
	libdir=%_tcllibdir tclrldir=%_tcllibdir/%teaname

%files
%doc AUTHORS COPYING ChangeLog README.md TODO sample.tclshrc
%_tcllibdir/lib%{srcname}*.so
%_tcllibdir/%teaname
%_mandir/mann/%srcname.n.*

%changelog
